/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAnchor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrEmpty;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrExclusion;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantified;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;

public class Patterns {
    private Patterns() {
    }

    public static IrLabel label(String name) {
        return new IrLabel(name);
    }

    public static IrRowPattern empty() {
        return new IrEmpty();
    }

    public static IrRowPattern excluded(IrRowPattern pattern) {
        return new IrExclusion(pattern);
    }

    public static IrRowPattern start() {
        return new IrAnchor(IrAnchor.Type.PARTITION_START);
    }

    public static IrRowPattern end() {
        return new IrAnchor(IrAnchor.Type.PARTITION_END);
    }

    public static IrRowPattern plusQuantified(IrRowPattern pattern, boolean greedy) {
        return new IrQuantified(pattern, IrQuantifier.oneOrMore(greedy));
    }

    public static IrRowPattern starQuantified(IrRowPattern pattern, boolean greedy) {
        return new IrQuantified(pattern, IrQuantifier.zeroOrMore(greedy));
    }

    public static IrRowPattern questionMarkQuantified(IrRowPattern pattern, boolean greedy) {
        return new IrQuantified(pattern, IrQuantifier.zeroOrOne(greedy));
    }

    public static IrRowPattern rangeQuantified(IrRowPattern pattern, int atLeast, Optional<Integer> atMost, boolean greedy) {
        return new IrQuantified(pattern, new IrQuantifier(atLeast, atMost, greedy));
    }

    public static IrRowPattern alternation(IrRowPattern ... parts) {
        return new IrAlternation((List<IrRowPattern>)ImmutableList.copyOf((Object[])parts));
    }

    public static IrRowPattern concatenation(IrRowPattern ... parts) {
        return new IrConcatenation((List<IrRowPattern>)ImmutableList.copyOf((Object[])parts));
    }

    public static IrRowPattern permutation(IrRowPattern ... parts) {
        return new IrPermutation((List<IrRowPattern>)ImmutableList.copyOf((Object[])parts));
    }
}

