/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.net;

import java.util.Set;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.net.INetMetricManager;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;

public class NetMetrics
implements IMetricSet {
    private final INetMetricManager netMetricManager = INetMetricManager.getNetMetricManager();
    private static final String RECEIVE = "receive";
    private static final String TRANSMIT = "transmit";
    private final String processName;

    public NetMetrics(String processName) {
        this.processName = processName;
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        Set<String> ifaceSet = this.netMetricManager.getIfaceSet();
        for (String iface : ifaceSet) {
            metricService.createAutoGauge(SystemMetric.RECEIVED_BYTES.toString(), MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getReceivedByte().getOrDefault(iface, 0L).doubleValue(), SystemTag.TYPE.toString(), RECEIVE, SystemTag.IFACE_NAME.toString(), iface);
            metricService.createAutoGauge(SystemMetric.TRANSMITTED_BYTES.toString(), MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getTransmittedBytes().getOrDefault(iface, 0L).doubleValue(), SystemTag.TYPE.toString(), TRANSMIT, SystemTag.IFACE_NAME.toString(), iface);
            metricService.createAutoGauge(SystemMetric.RECEIVED_PACKETS.toString(), MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getReceivedPackets().getOrDefault(iface, 0L).doubleValue(), SystemTag.TYPE.toString(), RECEIVE, SystemTag.IFACE_NAME.toString(), iface);
            metricService.createAutoGauge(SystemMetric.TRANSMITTED_PACKETS.toString(), MetricLevel.IMPORTANT, this.netMetricManager, x -> x.getTransmittedPackets().getOrDefault(iface, 0L).doubleValue(), SystemTag.TYPE.toString(), TRANSMIT, SystemTag.IFACE_NAME.toString(), iface);
        }
        metricService.createAutoGauge(SystemMetric.CONNECTION_NUM.toString(), MetricLevel.NORMAL, this.netMetricManager, INetMetricManager::getConnectionNum, SystemTag.PROCESS_NAME.toString(), this.processName);
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        Set<String> ifaceSet = this.netMetricManager.getIfaceSet();
        for (String iface : ifaceSet) {
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.RECEIVED_BYTES.toString(), SystemTag.TYPE.toString(), RECEIVE, SystemTag.IFACE_NAME.toString(), iface);
            metricService.remove(MetricType.AUTO_GAUGE, TRANSMIT, SystemTag.TYPE.toString(), TRANSMIT, SystemTag.IFACE_NAME.toString(), iface);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.RECEIVED_PACKETS.toString(), SystemTag.TYPE.toString(), RECEIVE, SystemTag.IFACE_NAME.toString(), iface);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.TRANSMITTED_PACKETS.toString(), SystemTag.TYPE.toString(), TRANSMIT, SystemTag.IFACE_NAME.toString(), iface);
        }
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.CONNECTION_NUM.toString(), SystemTag.PROCESS_NAME.toString(), this.processName);
    }
}

