/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.enums;

import com.codahale.metrics.Meter;

public enum PipeRateAverage {
    NONE,
    ONE_MINUTE,
    FIVE_MINUTES,
    FIFTEEN_MINUTES,
    MEAN;


    public double getMeterRate(Meter meter) {
        switch (this) {
            case ONE_MINUTE: {
                return meter.getOneMinuteRate();
            }
            case FIVE_MINUTES: {
                return meter.getFiveMinuteRate();
            }
            case FIFTEEN_MINUTES: {
                return meter.getFifteenMinuteRate();
            }
            case MEAN: {
                return meter.getMeanRate();
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s is not supported in pipe rate average.", new Object[]{this}));
    }
}

