/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class MarkDistinctNode
extends SingleChildProcessNode {
    private final Symbol markerSymbol;
    private final Optional<Symbol> hashSymbol;
    private final List<Symbol> distinctSymbols;

    public MarkDistinctNode(PlanNodeId id, PlanNode child, Symbol markerSymbol, List<Symbol> distinctSymbols, Optional<Symbol> hashSymbol) {
        super(id);
        this.child = child;
        this.markerSymbol = Objects.requireNonNull(markerSymbol, "markerSymbol is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        Objects.requireNonNull(distinctSymbols, "distinctSymbols is null");
        Preconditions.checkArgument((!distinctSymbols.isEmpty() ? 1 : 0) != 0, (Object)"distinctSymbols cannot be empty");
        this.distinctSymbols = ImmutableList.copyOf(distinctSymbols);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.child.getOutputSymbols()).add((Object)this.markerSymbol).build();
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public PlanNode clone() {
        return new MarkDistinctNode(this.id, this.child, this.markerSymbol, this.distinctSymbols, this.hashSymbol);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    public Symbol getMarkerSymbol() {
        return this.markerSymbol;
    }

    public List<Symbol> getDistinctSymbols() {
        return this.distinctSymbols;
    }

    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMarkDistinct(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.MARK_DISTINCT_NODE.serialize(byteBuffer);
        Symbol.serialize(this.markerSymbol, byteBuffer);
        if (this.hashSymbol.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            Symbol.serialize(this.hashSymbol.get(), byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.distinctSymbols.size(), (ByteBuffer)byteBuffer);
        for (Symbol distinctSymbol : this.distinctSymbols) {
            Symbol.serialize(distinctSymbol, byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.MARK_DISTINCT_NODE.serialize(stream);
        Symbol.serialize(this.markerSymbol, stream);
        if (this.hashSymbol.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            Symbol.serialize(this.hashSymbol.get(), stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.distinctSymbols.size(), (OutputStream)stream);
        for (Symbol distinctSymbol : this.distinctSymbols) {
            Symbol.serialize(distinctSymbol, stream);
        }
    }

    public static MarkDistinctNode deserialize(ByteBuffer byteBuffer) {
        Symbol markerSymbol = Symbol.deserialize(byteBuffer);
        Optional<Symbol> hashSymbol = Optional.empty();
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            hashSymbol = Optional.of(Symbol.deserialize(byteBuffer));
        }
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> distinctSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            distinctSymbols.add(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new MarkDistinctNode(planNodeId, null, markerSymbol, distinctSymbols, hashSymbol);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new MarkDistinctNode(this.getPlanNodeId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.markerSymbol, this.distinctSymbols, this.hashSymbol);
    }
}

