/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.partition;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.ConfigPhysicalReadPlan;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;

public class GetDataPartitionPlan
extends ConfigPhysicalReadPlan {
    protected Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> partitionSlotsMap;

    public GetDataPartitionPlan(ConfigPhysicalPlanType configPhysicalPlanType) {
        super(configPhysicalPlanType);
    }

    public GetDataPartitionPlan(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> partitionSlotsMap) {
        super(ConfigPhysicalPlanType.GetDataPartition);
        this.partitionSlotsMap = partitionSlotsMap;
    }

    public Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> getPartitionSlotsMap() {
        return this.partitionSlotsMap;
    }

    public static GetDataPartitionPlan convertFromRpcTDataPartitionReq(TDataPartitionReq req) {
        return new GetDataPartitionPlan(new ConcurrentHashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>>(req.getPartitionSlotsMap()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataPartitionPlan that = (GetDataPartitionPlan)o;
        return this.partitionSlotsMap.equals(that.partitionSlotsMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionSlotsMap);
    }
}

