/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import org.apache.tsfile.file.MetaMarker;
import org.apache.tsfile.file.header.ChunkGroupHeader;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;

public abstract class TsFileSequenceScan {
    protected PrintWriter printWriter = null;
    protected TsFileSequenceReader reader;
    protected byte marker;
    protected File file;
    protected IDeviceID currDeviceID;
    protected String currMeasurementID;
    protected Pair<IDeviceID, String> currTimeseriesID;
    protected boolean currChunkOnePage;

    protected boolean onFileOpen(File file) throws IOException {
        this.reader.position((long)"TsFile".getBytes().length + 1L);
        this.file = file;
        return true;
    }

    protected void onFileEnd() throws IOException {
    }

    protected void onChunk(PageVisitor pageVisitor) throws IOException {
        PageHeader pageHeader;
        ChunkHeader chunkHeader = this.reader.readChunkHeader(this.marker);
        if (chunkHeader.getDataSize() == 0) {
            return;
        }
        this.currMeasurementID = chunkHeader.getMeasurementID();
        this.currTimeseriesID = new Pair((Object)this.currDeviceID, (Object)this.currMeasurementID);
        for (int dataSize = chunkHeader.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
            pageHeader = this.reader.readPageHeader(chunkHeader.getDataType(), (chunkHeader.getChunkType() & 0x3F) == 1);
            ByteBuffer pageData = this.reader.readPage(pageHeader, chunkHeader.getCompressionType());
            pageVisitor.onPage(pageHeader, pageData, chunkHeader);
        }
    }

    protected void onChunkGroup() throws IOException {
        ChunkGroupHeader chunkGroupHeader = this.reader.readChunkGroupHeader();
        this.currDeviceID = chunkGroupHeader.getDeviceID();
    }

    protected abstract void onTimePage(PageHeader var1, ByteBuffer var2, ChunkHeader var3) throws IOException;

    protected abstract void onValuePage(PageHeader var1, ByteBuffer var2, ChunkHeader var3) throws IOException;

    protected abstract void onNonAlignedPage(PageHeader var1, ByteBuffer var2, ChunkHeader var3) throws IOException;

    protected void printBoth(String msg) {
        System.out.println(msg);
        if (this.printWriter != null) {
            this.printWriter.println(msg);
        }
    }

    protected abstract void onException(Throwable var1);

    public void scanTsFile(File tsFile) {
        try (TsFileSequenceReader r = new TsFileSequenceReader(tsFile.getAbsolutePath());){
            this.reader = r;
            boolean shouldScan = this.onFileOpen(tsFile);
            if (!shouldScan) {
                return;
            }
            block18: while ((this.marker = this.reader.readMarker()) != 2) {
                switch (this.marker) {
                    case 5: {
                        this.currChunkOnePage = true;
                        this.onChunk(this::onNonAlignedPage);
                        continue block18;
                    }
                    case 1: {
                        this.currChunkOnePage = false;
                        this.onChunk(this::onNonAlignedPage);
                        continue block18;
                    }
                    case -123: {
                        this.currChunkOnePage = true;
                        this.onChunk(this::onTimePage);
                        continue block18;
                    }
                    case -127: {
                        this.currChunkOnePage = false;
                        this.onChunk(this::onTimePage);
                        continue block18;
                    }
                    case 69: {
                        this.currChunkOnePage = true;
                        this.onChunk(this::onValuePage);
                        continue block18;
                    }
                    case 65: {
                        this.currChunkOnePage = false;
                        this.onChunk(this::onValuePage);
                        continue block18;
                    }
                    case 0: {
                        this.onChunkGroup();
                        continue block18;
                    }
                    case 4: {
                        this.reader.readPlanIndex();
                        continue block18;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)this.marker);
            }
            this.onFileEnd();
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    protected static interface PageVisitor {
        public void onPage(PageHeader var1, ByteBuffer var2, ChunkHeader var3) throws IOException;
    }
}

