/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.connector;

import java.util.Objects;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.agent.task.connection.BlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.agent.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;

public class PipeRealtimePriorityBlockingQueue
extends UnboundedBlockingPendingQueue<Event> {
    private final BlockingDeque<TsFileInsertionEvent> tsfileInsertEventDeque = new LinkedBlockingDeque<TsFileInsertionEvent>();
    private static final int POLL_TSFILE_THRESHOLD = PipeConfig.getInstance().getPipeRealTimeQueuePollTsFileThreshold();
    private final AtomicInteger pollTsFileCounter = new AtomicInteger(0);
    private static final int POLL_HISTORICAL_TSFILE_THRESHOLD = Math.max(PipeConfig.getInstance().getPipeRealTimeQueuePollHistoricalTsFileThreshold(), 1);
    private final AtomicLong pollHistoricalTsFileCounter = new AtomicLong(0L);

    public PipeRealtimePriorityBlockingQueue() {
        super((PipeEventCounter)new PipeDataRegionEventCounter());
    }

    public boolean directOffer(Event event) {
        this.checkBeforeOffer(event);
        if (event instanceof TsFileInsertionEvent) {
            this.tsfileInsertEventDeque.add((TsFileInsertionEvent)event);
            return true;
        }
        if (event instanceof PipeHeartbeatEvent && super.peekLast() instanceof PipeHeartbeatEvent) {
            ((EnrichedEvent)event).decreaseReferenceCount(PipeEventCollector.class.getName(), false);
            return false;
        }
        return super.directOffer(event);
    }

    public boolean waitedOffer(Event event) {
        return this.directOffer(event);
    }

    public boolean put(Event event) {
        this.directOffer(event);
        return true;
    }

    public Event directPoll() {
        Event event = null;
        if (this.pollTsFileCounter.get() >= POLL_TSFILE_THRESHOLD) {
            event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)POLL_HISTORICAL_TSFILE_THRESHOLD == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            this.pollTsFileCounter.set(0);
        }
        if (Objects.isNull(event)) {
            event = super.directPoll();
            if (Objects.isNull(event)) {
                Event event2 = event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)POLL_HISTORICAL_TSFILE_THRESHOLD == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            }
            if (event != null) {
                this.pollTsFileCounter.incrementAndGet();
            }
        }
        return event;
    }

    public Event waitedPoll() {
        Event event = null;
        if (this.pollTsFileCounter.get() >= POLL_TSFILE_THRESHOLD) {
            event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)POLL_HISTORICAL_TSFILE_THRESHOLD == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            this.pollTsFileCounter.set(0);
        }
        if (event == null) {
            event = super.directPoll();
            if (event == null && !this.tsfileInsertEventDeque.isEmpty()) {
                Event event2 = event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)POLL_HISTORICAL_TSFILE_THRESHOLD == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            }
            if (event != null) {
                this.pollTsFileCounter.incrementAndGet();
            }
        }
        if (Objects.isNull(event)) {
            event = super.waitedPoll();
            if (Objects.isNull(event)) {
                Event event3 = event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)POLL_HISTORICAL_TSFILE_THRESHOLD == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            }
            if (event != null) {
                this.pollTsFileCounter.incrementAndGet();
            }
        }
        return event;
    }

    public Event peek() {
        Event event = (Event)this.pendingQueue.peek();
        if (Objects.nonNull(event)) {
            return event;
        }
        return (Event)this.tsfileInsertEventDeque.peek();
    }

    public void clear() {
        super.clear();
        this.tsfileInsertEventDeque.clear();
    }

    public void forEach(Consumer<? super Event> action) {
        super.forEach(action);
        this.tsfileInsertEventDeque.forEach(action);
    }

    public void discardAllEvents() {
        super.discardAllEvents();
        this.tsfileInsertEventDeque.removeIf(event -> {
            if (event instanceof EnrichedEvent && ((EnrichedEvent)event).clearReferenceCount(BlockingPendingQueue.class.getName())) {
                this.eventCounter.decreaseEventCount((Event)event);
            }
            return true;
        });
        this.eventCounter.reset();
    }

    public void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        super.discardEventsOfPipe(pipeNameToDrop, regionId);
        this.tsfileInsertEventDeque.removeIf(event -> {
            if (event instanceof EnrichedEvent && pipeNameToDrop.equals(((EnrichedEvent)event).getPipeName()) && regionId == ((EnrichedEvent)event).getRegionId()) {
                if (((EnrichedEvent)event).clearReferenceCount(PipeRealtimePriorityBlockingQueue.class.getName())) {
                    this.eventCounter.decreaseEventCount((Event)event);
                }
                return true;
            }
            return false;
        });
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.tsfileInsertEventDeque.isEmpty();
    }

    public int size() {
        return super.size() + this.tsfileInsertEventDeque.size();
    }

    public int getTsFileInsertionEventCount() {
        return this.tsfileInsertEventDeque.size();
    }
}

