/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.lang.Nullable;

class StaticMasterReplicaConnectionProvider
implements LettuceConnectionProvider {
    private final RedisClient client;
    private final RedisCodec<?, ?> codec;
    private final Optional<ReadFrom> readFrom;
    private final Collection<RedisURI> nodes;

    StaticMasterReplicaConnectionProvider(RedisClient client, RedisCodec<?, ?> codec, Collection<RedisURI> nodes, @Nullable ReadFrom readFrom) {
        this.client = client;
        this.codec = codec;
        this.readFrom = Optional.ofNullable(readFrom);
        this.nodes = nodes;
    }

    @Override
    public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        if (connectionType.equals(StatefulRedisPubSubConnection.class)) {
            throw new UnsupportedOperationException("Pub/Sub connections not supported with Master/Replica configurations");
        }
        if (StatefulConnection.class.isAssignableFrom(connectionType)) {
            StatefulRedisMasterReplicaConnection connection = MasterReplica.connect((RedisClient)this.client, this.codec, this.nodes);
            this.readFrom.ifPresent(arg_0 -> ((StatefulRedisMasterReplicaConnection)connection).setReadFrom(arg_0));
            return (T)((StatefulConnection)connectionType.cast(connection));
        }
        throw new UnsupportedOperationException(String.format("Connection type %s not supported!", connectionType));
    }

    @Override
    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
        if (StatefulConnection.class.isAssignableFrom(connectionType)) {
            CompletableFuture connection = MasterReplica.connectAsync((RedisClient)this.client, this.codec, this.nodes);
            return connection.thenApply(it -> {
                this.readFrom.ifPresent(readFrom -> it.setReadFrom(readFrom));
                return (StatefulConnection)connectionType.cast(it);
            });
        }
        throw new UnsupportedOperationException(String.format("Connection type %s not supported!", connectionType));
    }
}

