/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisURI;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.connection.lettuce.DefaultLettuceClientConfiguration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface LettuceClientConfiguration {
    public boolean isUseSsl();

    public boolean isVerifyPeer();

    public boolean isStartTls();

    public Optional<ClientResources> getClientResources();

    public Optional<ClientOptions> getClientOptions();

    public Optional<String> getClientName();

    public Optional<ReadFrom> getReadFrom();

    public Duration getCommandTimeout();

    public Duration getShutdownTimeout();

    public Duration getShutdownQuietPeriod();

    public static LettuceClientConfigurationBuilder builder() {
        return new LettuceClientConfigurationBuilder();
    }

    public static LettuceClientConfiguration defaultConfiguration() {
        return LettuceClientConfiguration.builder().build();
    }

    public static class LettuceSslClientConfigurationBuilder {
        private LettuceClientConfigurationBuilder delegate;

        LettuceSslClientConfigurationBuilder(LettuceClientConfigurationBuilder delegate) {
            Assert.notNull((Object)delegate, (String)"Delegate client configuration builder must not be null!");
            this.delegate = delegate;
        }

        public LettuceSslClientConfigurationBuilder disablePeerVerification() {
            this.delegate.verifyPeer = false;
            return this;
        }

        public LettuceSslClientConfigurationBuilder startTls() {
            this.delegate.startTls = true;
            return this;
        }

        public LettuceClientConfigurationBuilder and() {
            return this.delegate;
        }

        public LettuceClientConfiguration build() {
            return this.delegate.build();
        }
    }

    public static class LettuceClientConfigurationBuilder {
        boolean useSsl;
        boolean verifyPeer = true;
        boolean startTls;
        @Nullable
        ClientResources clientResources;
        ClientOptions clientOptions = ClientOptions.builder().timeoutOptions(TimeoutOptions.enabled()).build();
        @Nullable
        String clientName;
        @Nullable
        ReadFrom readFrom;
        Duration timeout = Duration.ofSeconds(60L);
        Duration shutdownTimeout = Duration.ofMillis(100L);
        @Nullable
        Duration shutdownQuietPeriod;

        LettuceClientConfigurationBuilder() {
        }

        public LettuceClientConfigurationBuilder apply(RedisURI redisUri) {
            this.useSsl = redisUri.isSsl();
            this.verifyPeer = redisUri.isVerifyPeer();
            this.startTls = redisUri.isStartTls();
            if (!redisUri.getTimeout().equals(RedisURI.DEFAULT_TIMEOUT_DURATION)) {
                this.timeout = redisUri.getTimeout();
            }
            if (!ObjectUtils.isEmpty((Object)redisUri.getClientName())) {
                this.clientName = redisUri.getClientName();
            }
            return this;
        }

        public LettuceSslClientConfigurationBuilder useSsl() {
            this.useSsl = true;
            return new LettuceSslClientConfigurationBuilder(this);
        }

        public LettuceClientConfigurationBuilder clientResources(ClientResources clientResources) {
            Assert.notNull((Object)clientResources, (String)"ClientResources must not be null!");
            this.clientResources = clientResources;
            return this;
        }

        public LettuceClientConfigurationBuilder clientOptions(ClientOptions clientOptions) {
            Assert.notNull((Object)clientOptions, (String)"ClientOptions must not be null!");
            this.clientOptions = clientOptions;
            return this;
        }

        public LettuceClientConfigurationBuilder readFrom(ReadFrom readFrom) {
            Assert.notNull((Object)readFrom, (String)"ReadFrom must not be null!");
            this.readFrom = readFrom;
            return this;
        }

        public LettuceClientConfigurationBuilder clientName(String clientName) {
            Assert.hasText((String)clientName, (String)"Client name must not be null or empty!");
            this.clientName = clientName;
            return this;
        }

        public LettuceClientConfigurationBuilder commandTimeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"Duration must not be null!");
            this.timeout = timeout;
            return this;
        }

        public LettuceClientConfigurationBuilder shutdownTimeout(Duration shutdownTimeout) {
            Assert.notNull((Object)shutdownTimeout, (String)"Duration must not be null!");
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public LettuceClientConfigurationBuilder shutdownQuietPeriod(Duration shutdownQuietPeriod) {
            Assert.notNull((Object)shutdownQuietPeriod, (String)"Duration must not be null!");
            this.shutdownQuietPeriod = shutdownQuietPeriod;
            return this;
        }

        public LettuceClientConfiguration build() {
            return new DefaultLettuceClientConfiguration(this.useSsl, this.verifyPeer, this.startTls, this.clientResources, this.clientOptions, this.clientName, this.readFrom, this.timeout, this.shutdownTimeout, this.shutdownQuietPeriod);
        }
    }
}

