/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationClusterComparator;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationClusterInvoker;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationRule;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationStep;
import org.apache.dubbo.rpc.cluster.support.wrapper.MockClusterInvoker;

public class ZoneAwareClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(ZoneAwareClusterInvoker.class);
    private static final String PREFER_REGISTRY_WITH_ZONE_KEY = "registry.zone";
    private final LoadBalance loadBalanceAmongRegistries = ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension("random");

    public ZoneAwareClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        Invoker<T> balancedInvoker;
        for (Invoker<T> invoker2 : invokers) {
            ClusterInvoker clusterInvoker = (ClusterInvoker)invoker2;
            if (!clusterInvoker.isAvailable() || !clusterInvoker.getRegistryUrl().getParameter("registry.preferred", false)) continue;
            return clusterInvoker.invoke(invocation);
        }
        String zone = invocation.getAttachment("registry_zone");
        if (StringUtils.isNotEmpty(zone)) {
            for (Invoker invoker2 : invokers) {
                ClusterInvoker clusterInvoker = (ClusterInvoker)invoker2;
                if (!clusterInvoker.isAvailable() || !zone.equals(clusterInvoker.getRegistryUrl().getParameter(PREFER_REGISTRY_WITH_ZONE_KEY))) continue;
                return clusterInvoker.invoke(invocation);
            }
            String force = invocation.getAttachment("registry_zone_force");
            if (StringUtils.isNotEmpty(force) && "true".equalsIgnoreCase(force)) {
                throw new IllegalStateException("No registry instance in zone or no available providers in the registry, zone: " + zone + ", registries: " + invokers.stream().map(invoker -> ((MockClusterInvoker)invoker).getRegistryUrl().toString()).collect(Collectors.joining(",")));
            }
        }
        if ((balancedInvoker = this.select(this.loadBalanceAmongRegistries, invocation, invokers, null)).isAvailable()) {
            return balancedInvoker.invoke(invocation);
        }
        for (Invoker<T> invoker4 : invokers) {
            ClusterInvoker clusterInvoker = (ClusterInvoker)invoker4;
            if (!clusterInvoker.isAvailable()) continue;
            return clusterInvoker.invoke(invocation);
        }
        return invokers.get(0).invoke(invocation);
    }

    @Override
    protected List<Invoker<T>> list(Invocation invocation) throws RpcException {
        List invokers = super.list(invocation);
        if (null == invokers || invokers.size() < 2) {
            return invokers;
        }
        ArrayList<Invoker<T>> interfaceInvokers = new ArrayList<Invoker<T>>();
        ArrayList<Invoker<T>> serviceInvokers = new ArrayList<Invoker<T>>();
        boolean addressChanged = false;
        for (Invoker invoker : invokers) {
            MigrationClusterInvoker migrationClusterInvoker = (MigrationClusterInvoker)invoker;
            if (migrationClusterInvoker.isServiceInvoker()) {
                serviceInvokers.add(invoker);
            } else {
                interfaceInvokers.add(invoker);
            }
            if (!migrationClusterInvoker.invokersChanged().compareAndSet(true, false)) continue;
            addressChanged = true;
        }
        if (serviceInvokers.isEmpty() || interfaceInvokers.isEmpty()) {
            return invokers;
        }
        MigrationRule rule = null;
        for (Invoker invoker : serviceInvokers) {
            MigrationClusterInvoker migrationClusterInvoker = (MigrationClusterInvoker)invoker;
            if (rule == null) {
                rule = migrationClusterInvoker.getMigrationRule();
                continue;
            }
            if (rule.equals(migrationClusterInvoker.getMigrationRule())) continue;
            rule = MigrationRule.queryRule();
            break;
        }
        MigrationStep step = rule.getStep();
        switch (step) {
            case FORCE_INTERFACE: {
                this.clusterRefresh(addressChanged, interfaceInvokers);
                this.clusterDestroy(addressChanged, serviceInvokers, true);
                if (logger.isDebugEnabled()) {
                    logger.debug("step is FORCE_INTERFACE");
                }
                return interfaceInvokers;
            }
            case APPLICATION_FIRST: {
                boolean bl;
                this.clusterRefresh(addressChanged, serviceInvokers);
                this.clusterRefresh(addressChanged, interfaceInvokers);
                boolean bl2 = bl = !serviceInvokers.isEmpty();
                if (bl && this.shouldMigrate(addressChanged, serviceInvokers, interfaceInvokers)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("step is APPLICATION_FIRST shouldMigrate true get serviceInvokers");
                    }
                    return serviceInvokers;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("step is APPLICATION_FIRST " + (serviceInvokers.isEmpty() ? "serviceInvokers is empty" : "shouldMigrate false") + " get interfaceInvokers");
                }
                return interfaceInvokers;
            }
            case FORCE_APPLICATION: {
                this.clusterRefresh(addressChanged, serviceInvokers);
                this.clusterDestroy(addressChanged, interfaceInvokers, true);
                if (logger.isDebugEnabled()) {
                    logger.debug("step is FORCE_APPLICATION");
                }
                return serviceInvokers;
            }
        }
        throw new UnsupportedOperationException(rule.getStep().name());
    }

    private boolean shouldMigrate(boolean addressChanged, List<Invoker<T>> serviceInvokers, List<Invoker<T>> interfaceInvokers) {
        Set<MigrationClusterComparator> detectors = ExtensionLoader.getExtensionLoader(MigrationClusterComparator.class).getSupportedExtensionInstances();
        if (detectors != null && !detectors.isEmpty()) {
            return detectors.stream().allMatch(s -> s.shouldMigrate(interfaceInvokers, serviceInvokers));
        }
        List availableServiceInvokers = serviceInvokers.stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
        return !availableServiceInvokers.isEmpty();
    }

    private void clusterDestroy(boolean addressChanged, List<Invoker<T>> invokers, boolean destroySub) {
        if (addressChanged) {
            invokers.forEach(s -> {
                MigrationClusterInvoker invoker = (MigrationClusterInvoker)s;
                if (invoker.isServiceInvoker()) {
                    invoker.discardServiceDiscoveryInvokerAddress(invoker);
                    if (destroySub) {
                        invoker.destroyServiceDiscoveryInvoker(invoker);
                    }
                } else {
                    invoker.discardInterfaceInvokerAddress(invoker);
                    if (destroySub) {
                        invoker.destroyInterfaceInvoker(invoker);
                    }
                }
            });
        }
    }

    private void clusterRefresh(boolean addressChanged, List<Invoker<T>> invokers) {
        if (addressChanged) {
            invokers.forEach(s -> {
                MigrationClusterInvoker invoker = (MigrationClusterInvoker)s;
                if (invoker.isServiceInvoker()) {
                    invoker.refreshServiceDiscoveryInvoker();
                } else {
                    invoker.refreshInterfaceInvoker();
                }
            });
        }
    }
}

