/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.Merger;
import org.apache.dubbo.rpc.cluster.merger.MergerFactory;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public class MergeableClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger log = LoggerFactory.getLogger(MergeableClusterInvoker.class);

    public MergeableClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    protected Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        Class<?> returnType;
        this.checkInvokers(invokers, invocation);
        String merger = this.getUrl().getMethodParameter(invocation.getMethodName(), "merger");
        if (ConfigUtils.isEmpty(merger)) {
            for (Invoker<T> invoker : invokers) {
                if (!invoker.isAvailable()) continue;
                try {
                    return invoker.invoke(invocation);
                }
                catch (RpcException e) {
                    if (e.isNoInvokerAvailableAfterFilter()) {
                        log.debug("No available provider for service" + this.getUrl().getServiceKey() + " on group " + invoker.getUrl().getParameter("group") + ", will continue to try another group.");
                        continue;
                    }
                    throw e;
                }
            }
            return invokers.iterator().next().invoke(invocation);
        }
        try {
            returnType = this.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes()).getReturnType();
        }
        catch (NoSuchMethodException e) {
            returnType = null;
        }
        HashMap<String, Result> results = new HashMap<String, Result>();
        for (Invoker<T> invoker : invokers) {
            RpcInvocation subInvocation = new RpcInvocation(invocation, invoker);
            subInvocation.setAttachment("async", "true");
            results.put(invoker.getUrl().getServiceKey(), invoker.invoke(subInvocation));
        }
        Object result = null;
        ArrayList<Result> resultList = new ArrayList<Result>(results.size());
        for (Map.Entry entry : results.entrySet()) {
            Result asyncResult = (Result)entry.getValue();
            try {
                Result r = asyncResult.get();
                if (r.hasException()) {
                    log.error("Invoke " + this.getGroupDescFromServiceKey((String)entry.getKey()) + " failed: " + r.getException().getMessage(), r.getException());
                    continue;
                }
                resultList.add(r);
            }
            catch (Exception e) {
                throw new RpcException("Failed to invoke service " + (String)entry.getKey() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (resultList.isEmpty()) {
            return AsyncRpcResult.newDefaultAsyncResult(invocation);
        }
        if (resultList.size() == 1) {
            return AsyncRpcResult.newDefaultAsyncResult(((Result)resultList.get(0)).getValue(), invocation);
        }
        if (returnType == Void.TYPE) {
            return AsyncRpcResult.newDefaultAsyncResult(invocation);
        }
        if (merger.startsWith(".")) {
            Method method;
            merger = merger.substring(1);
            try {
                method = returnType.getMethod(merger, returnType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RpcException("Can not merge result because missing method [ " + merger + " ] in class [ " + returnType.getName() + " ]");
            }
            ReflectUtils.makeAccessible(method);
            result = ((Result)resultList.remove(0)).getValue();
            try {
                if (method.getReturnType() != Void.TYPE && method.getReturnType().isAssignableFrom(result.getClass())) {
                    for (Result r : resultList) {
                        result = method.invoke(result, r.getValue());
                    }
                }
                for (Result r : resultList) {
                    method.invoke(result, r.getValue());
                }
            }
            catch (Exception exception) {
                throw new RpcException("Can not merge result: " + exception.getMessage(), (Throwable)exception);
            }
        } else {
            Merger resultMerger = ConfigUtils.isDefault(merger) ? MergerFactory.getMerger(returnType) : ExtensionLoader.getExtensionLoader(Merger.class).getExtension(merger);
            if (resultMerger != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(resultList.size());
                for (Result r : resultList) {
                    arrayList.add(r.getValue());
                }
                result = resultMerger.merge(arrayList.toArray((Object[])Array.newInstance(returnType, 0)));
            } else {
                throw new RpcException("There is no merger to merge result.");
            }
        }
        return AsyncRpcResult.newDefaultAsyncResult(result, invocation);
    }

    @Override
    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    @Override
    public boolean isAvailable() {
        return this.directory.isAvailable();
    }

    @Override
    public void destroy() {
        this.directory.destroy();
    }

    private String getGroupDescFromServiceKey(String key) {
        int index = key.indexOf("/");
        if (index > 0) {
            return "group [ " + key.substring(0, index) + " ]";
        }
        return key;
    }
}

