/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.ExecutionException;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.support.MultiMessage;
import org.apache.dubbo.remoting.transport.AbstractChannelHandlerDelegate;

public class MultiMessageHandler
extends AbstractChannelHandlerDelegate {
    protected static final Logger logger = LoggerFactory.getLogger(MultiMessageHandler.class);

    public MultiMessageHandler(ChannelHandler handler) {
        super(handler);
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        if (message instanceof MultiMessage) {
            MultiMessage list = (MultiMessage)message;
            for (Object obj : list) {
                try {
                    this.handler.received(channel, obj);
                }
                catch (ExecutionException e) {
                    logger.error("MultiMessageHandler received fail.", e);
                    this.handler.caught(channel, e);
                }
            }
        } else {
            this.handler.received(channel, message);
        }
    }
}

