/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.config;

import com.alibaba.spring.beans.factory.config.GenericBeanPostProcessorAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.core.PriorityOrdered;

public class DubboConfigEarlyRegistrationPostProcessor
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered {
    public static final String BEAN_NAME = "dubboConfigEarlyRegistrationPostProcessor";
    private static final Log logger = LogFactory.getLog((String)DubboConfigEarlyRegistrationPostProcessor.class.getName());
    private DefaultListableBeanFactory beanFactory;
    private DubboConfigEarlyInitializationPostProcessor configEarlyInitializationPostProcessor = new DubboConfigEarlyInitializationPostProcessor();

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.beanFactory = this.unwrap(registry);
        this.registryConfigEarlyInitializationPostProcessor(this.beanFactory);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.beanFactory == null) {
            this.beanFactory = this.unwrap(beanFactory);
            this.registryConfigEarlyInitializationPostProcessor(this.beanFactory);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void registryConfigEarlyInitializationPostProcessor(DefaultListableBeanFactory beanFactory) {
        if (beanFactory != null) {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)this.configEarlyInitializationPostProcessor);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"DubboConfigEarlyInitializationPostProcessor has bean registered");
            }
        }
    }

    private DefaultListableBeanFactory unwrap(Object registry) {
        if (registry instanceof DefaultListableBeanFactory) {
            return (DefaultListableBeanFactory)registry;
        }
        return null;
    }

    class DubboConfigEarlyInitializationPostProcessor
    extends GenericBeanPostProcessorAdapter<AbstractConfig> {
        private boolean registeredCommonAnnotationBeanPostProcessor = false;

        DubboConfigEarlyInitializationPostProcessor() {
        }

        protected void processBeforeInitialization(AbstractConfig config, String beanName) throws BeansException {
            if (DubboConfigEarlyRegistrationPostProcessor.this.beanFactory == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Current Processor is not running in Spring container, next action will be skipped!");
                }
                return;
            }
            if (!this.hasRegisteredCommonAnnotationBeanPostProcessor()) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"CommonAnnotationBeanPostProcessor is not registered yet, the method addIntoConfigManager() will be invoked directly");
                }
                config.addIntoConfigManager();
            }
        }

        private boolean hasRegisteredCommonAnnotationBeanPostProcessor() {
            if (this.registeredCommonAnnotationBeanPostProcessor) {
                return true;
            }
            for (BeanPostProcessor beanPostProcessor : DubboConfigEarlyRegistrationPostProcessor.this.beanFactory.getBeanPostProcessors()) {
                if (!CommonAnnotationBeanPostProcessor.class.equals(beanPostProcessor.getClass())) continue;
                this.registeredCommonAnnotationBeanPostProcessor = true;
                return true;
            }
            return false;
        }
    }
}

