/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter;

import java.util.EventObject;
import java.util.Objects;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;

public class ConfigChangedEvent
extends EventObject {
    private final String key;
    private final String group;
    private final String content;
    private final ConfigChangeType changeType;

    public ConfigChangedEvent(String key, String group, String content) {
        this(key, group, content, ConfigChangeType.MODIFIED);
    }

    public ConfigChangedEvent(String key, String group, String content, ConfigChangeType changeType) {
        super(key + "," + group);
        this.key = key;
        this.group = group;
        this.content = content;
        this.changeType = changeType;
    }

    public String getKey() {
        return this.key;
    }

    public String getGroup() {
        return this.group;
    }

    public String getContent() {
        return this.content;
    }

    public ConfigChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public String toString() {
        return "ConfigChangedEvent{key='" + this.key + '\'' + ", group='" + this.group + '\'' + ", content='" + this.content + '\'' + ", changeType=" + (Object)((Object)this.changeType) + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigChangedEvent)) {
            return false;
        }
        ConfigChangedEvent that = (ConfigChangedEvent)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getContent(), that.getContent()) && this.getChangeType() == that.getChangeType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getKey(), this.getGroup(), this.getContent(), this.getChangeType()});
    }
}

