/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.es.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DubboConfiguration {
    @Value(value="${dubbo.protocol.port}")
    private int port;
    @Value(value="${server.port}")
    private String httpGateWayPort;
    @NacosValue(value="${dubbo.registry.address}")
    private String regAddress;

    @Bean
    public ApplicationConfig applicationConfig() {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName("Trace-etl-es");
        applicationConfig.setParameters((Map)Maps.newHashMap());
        applicationConfig.getParameters().put("http_gateway_port", this.httpGateWayPort);
        applicationConfig.getParameters().put("dubbo_version", "1.0");
        applicationConfig.setQosEnable(Boolean.valueOf(false));
        return applicationConfig;
    }

    @Bean
    public RegistryConfig registryConfig() {
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setAddress(this.regAddress);
        return registryConfig;
    }

    @Bean
    public ProtocolConfig protocolConfig() {
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setPort(Integer.valueOf(this.port));
        protocolConfig.setTransporter("netty4");
        protocolConfig.setThreadpool("fixed");
        protocolConfig.setThreads(Integer.valueOf(800));
        return protocolConfig;
    }
}

