/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file.listener;

import com.xiaomi.mone.file.LogFile2;
import com.xiaomi.mone.file.ReadEvent;
import com.xiaomi.mone.file.ReadListener;
import com.xiaomi.mone.file.common.SafeRun;
import com.xiaomi.mone.file.ozhera.HeraFile;
import com.xiaomi.mone.file.ozhera.HeraFileMonitor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzHeraReadListener
implements ReadListener {
    private static final Logger log = LoggerFactory.getLogger(OzHeraReadListener.class);
    private HeraFileMonitor monitor;
    private LogFile2 logFile;
    private Consumer<ReadEvent> consumer;

    public OzHeraReadListener(HeraFileMonitor monitor, LogFile2 logFile, Consumer<ReadEvent> consumer) {
        this.monitor = monitor;
        this.logFile = logFile;
        this.consumer = consumer;
    }

    @Override
    public void onEvent(ReadEvent event) {
        this.consumer.accept(event);
    }

    @Override
    public boolean isContinue(String line) {
        if (null == line) {
            SafeRun.run(() -> TimeUnit.MILLISECONDS.sleep(300L));
            return true;
        }
        return false;
    }

    @Override
    public void saveProgress() {
        this.logFile.saveProgress();
    }

    @Override
    public boolean isBreak(String line) {
        HeraFile f;
        if (null == line && (null == (f = this.monitor.getMap().get(this.logFile.getFileKey())) || f.getState().get() == 1)) {
            log.info("file isBreak,file:{},f:{}", (Object)this.logFile.getFile(), (Object)f);
            return true;
        }
        return false;
    }

    @Override
    public void setPointer(Object obj) {
        if (obj instanceof LogFile2) {
            LogFile2 lf = (LogFile2)obj;
            HeraFile f = this.monitor.getMap().get(this.logFile.getFileKey());
            if (null != f && f.getPointer().get() == -1L) {
                lf.setPointer(-1L);
                f.getPointer().set(0L);
            }
        }
    }

    @Override
    public void setReadTime() {
        HeraFile f = this.monitor.getFileMap().get(this.logFile.getFileKey());
        if (null != f) {
            f.getReadTime().set(System.currentTimeMillis());
        }
    }

    public LogFile2 getLogFile() {
        return this.logFile;
    }
}

