/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file;

import com.google.common.collect.Lists;
import com.xiaomi.mone.file.ILogFile;
import com.xiaomi.mone.file.MoneRandomAccessFile;
import com.xiaomi.mone.file.ReadEvent;
import com.xiaomi.mone.file.ReadListener;
import com.xiaomi.mone.file.ReadResult;
import com.xiaomi.mone.file.common.FileInfo;
import com.xiaomi.mone.file.common.FileInfoCache;
import com.xiaomi.mone.file.common.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFile2
implements ILogFile {
    private static final Logger log = LoggerFactory.getLogger(LogFile2.class);
    private String file;
    private Object fileKey;
    private MoneRandomAccessFile raf;
    private ReadListener listener;
    private volatile boolean stop;
    private volatile boolean reOpen;
    private volatile boolean reFresh;
    private volatile boolean exceptionFinish;
    private int beforePointerHashCode;
    private volatile long pointer;
    private long lineNumber;
    private long maxPointer;
    private String md5;

    public LogFile2() {
    }

    public LogFile2(String file, ReadListener listener) {
        this.file = file;
        File f = new File(this.file);
        this.fileKey = FileUtils.fileKey(f);
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = this.readPointer();
    }

    public LogFile2(String file) {
        this.file = file;
        File f = new File(this.file);
        this.fileKey = FileUtils.fileKey(f);
        this.md5 = this.md5(file);
        this.pointer = this.readPointer();
    }

    public LogFile2(String file, long pointer, long lineNumber) {
        this.file = file;
        File f = new File(this.file);
        this.fileKey = FileUtils.fileKey(f);
        this.md5 = this.md5(file);
        this.pointer = pointer;
        this.lineNumber = lineNumber;
    }

    public LogFile2(String file, ReadListener listener, long pointer, long lineNumber) {
        this.file = file;
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = pointer;
        this.lineNumber = lineNumber;
    }

    private void open() {
        try {
            this.raf = new MoneRandomAccessFile(this.file, "r", 4096);
            this.reOpen = false;
            this.reFresh = false;
        }
        catch (FileNotFoundException e) {
            log.error("open file FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("open file IOException", (Throwable)e);
        }
    }

    @Override
    public void readLine() throws IOException {
        do {
            this.open();
            try {
                log.info("open file:{},pointer:{},lineNumber:{},", new Object[]{this.file, this.pointer, this.lineNumber});
                if (this.pointer > this.raf.length()) {
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                }
            }
            catch (Exception e) {
                log.error("file.length() IOException, file:{}", (Object)this.file, (Object)e);
            }
            log.info("rel open file:{},pointer:{},lineNumber:{}", new Object[]{this.file, this.pointer, this.lineNumber});
            this.raf.seek(this.pointer);
            while (true) {
                this.listener.setPointer(this);
                if (this.pointer == -1L) {
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                    log.info("empty break");
                    break;
                }
                String line = this.raf.getNextLine();
                if (null != line && this.lineNumber == 0L && this.pointer == 0L) {
                    String hashLine = line.length() > 100 ? line.substring(0, 100) : line;
                    this.beforePointerHashCode = hashLine.hashCode();
                }
                line = this.lineCutOff(line);
                if (this.reFresh) break;
                if (this.reOpen) {
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                    break;
                }
                if (this.stop) break;
                if (this.contentHasCutting(line)) {
                    this.reOpen = true;
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                    log.warn("file:{} content have been cut, goto reOpen file", (Object)this.file);
                    break;
                }
                if (this.listener.isBreak(line)) {
                    log.info("isBreak:{},pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, this.fileKey});
                    this.stop = true;
                    break;
                }
                if (this.listener.isContinue(line)) continue;
                try {
                    this.pointer = this.raf.getFilePointer();
                    this.maxPointer = this.raf.length();
                }
                catch (IOException e) {
                    log.error("file.length() IOException, file:{}", (Object)this.file, (Object)e);
                }
                ReadResult readResult = new ReadResult();
                readResult.setLines(Lists.newArrayList((Object[])new String[]{line}));
                readResult.setPointer(this.pointer);
                readResult.setFileMaxPointer(this.maxPointer);
                readResult.setFilePathName(this.file);
                readResult.setLineNumber(++this.lineNumber);
                ReadEvent event = new ReadEvent(readResult);
                this.listener.setReadTime();
                this.listener.onEvent(event);
                if (this.pointer % 100000L != 0L && this.pointer != 1L) continue;
                log.info("file readResult:{}", (Object)readResult);
            }
            this.raf.close();
        } while (!this.stop);
        log.info("stop:{},pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, this.fileKey});
        FileInfoCache.ins().put(this.fileKey.toString(), FileInfo.builder().pointer(this.pointer).fileName(this.file).build());
        log.info("read file:{},finished,,pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, this.fileKey});
    }

    @Override
    public void initLogFile(String file, ReadListener listener, long pointer, long lineNumber) {
        this.file = file;
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = pointer;
        this.lineNumber = lineNumber;
    }

    @Override
    public void setExceptionFinish() {
        this.exceptionFinish = true;
    }

    @Override
    public boolean getExceptionFinish() {
        return this.exceptionFinish;
    }

    private String lineCutOff(String line) {
        if (null != line && line.length() > 1100000) {
            line = line.substring(0, 1100000);
        }
        return line;
    }

    private boolean contentHasCutting(String line) throws IOException {
        if (null != line) {
            return false;
        }
        try {
            long currentFileMaxLength = this.raf.length();
            if (currentFileMaxLength == 0L) {
                this.raf.getFD().sync();
                TimeUnit.MILLISECONDS.sleep(30L);
                currentFileMaxLength = this.raf.length();
            }
        }
        catch (IOException e) {
            log.error("get fileMaxPointer IOException", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.error("get fileMaxPointer InterruptedException", (Throwable)e);
            return false;
        }
        return false;
    }

    public void saveProgress() {
        if (!this.stop) {
            FileInfoCache.ins().put(this.fileKey.toString(), FileInfo.builder().pointer(this.pointer).fileName(this.file).build());
        }
    }

    public void shutdown() {
        try {
            this.stop = true;
            FileInfoCache.ins().put(this.fileKey.toString(), FileInfo.builder().pointer(this.pointer).fileName(this.file).build());
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
        }
    }

    public long readPointer() {
        try {
            FileInfo fi = FileInfoCache.ins().get(this.fileKey.toString());
            log.info("readPointer:{},file:{},fileKey:{}", new Object[]{fi, this.file, this.fileKey});
            if (null != fi && Objects.equals(this.file, fi.getFileName())) {
                return fi.getPointer();
            }
        }
        catch (Throwable e) {
            log.error("readPointer error,file:{},fileKey:{}", new Object[]{this.file, this.fileKey, e});
        }
        log.warn("readPointer from 0,file:{},fileKey:{}", (Object)this.file, this.fileKey);
        return 0L;
    }

    public String md5(String msg) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(msg.getBytes());
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(2 * digest.length);
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString().toUpperCase();
    }

    public String getFile() {
        return this.file;
    }

    public Object getFileKey() {
        return this.fileKey;
    }

    public MoneRandomAccessFile getRaf() {
        return this.raf;
    }

    public void setListener(ReadListener listener) {
        this.listener = listener;
    }

    @Override
    public void setStop(boolean stop) {
        this.stop = stop;
    }

    @Override
    public void setReOpen(boolean reOpen) {
        this.reOpen = reOpen;
    }

    public void setReFresh(boolean reFresh) {
        this.reFresh = reFresh;
    }

    public int getBeforePointerHashCode() {
        return this.beforePointerHashCode;
    }

    public void setPointer(long pointer) {
        this.pointer = pointer;
    }
}

