/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.processor;

import com.xiaomi.data.push.common.RpcCovertUtils;
import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.data.push.uds.codes.CodesFactory;
import com.xiaomi.data.push.uds.codes.ICodes;
import com.xiaomi.youpin.docean.common.MethodReq;
import com.xiaomi.youpin.docean.common.ReflectUtils;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.function.Function;

public class RpcCallMethodProcessor
implements NettyRequestProcessor {
    private final Function<MethodReq, Object> beanFactory;

    public RpcCallMethodProcessor(Function<MethodReq, Object> beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        byte[] body = request.getBody();
        ICodes codes = CodesFactory.getCodes((byte)3);
        MethodReq mr = (MethodReq)codes.decode(body, MethodReq.class);
        Object obj = this.beanFactory.apply(mr);
        Object res = null;
        HashMap<String, String> ext = new HashMap<String, String>();
        ext.put("code", "0");
        try {
            res = ReflectUtils.invokeMethod((MethodReq)mr, (Object)obj, (paramTypes, params) -> RpcCovertUtils.convert(paramTypes, params));
        }
        catch (Throwable ex) {
            ext.put("code", "500");
            ext.put("message", ex.getMessage());
        }
        RemotingCommand response = RemotingCommand.createResponseCommand(3001);
        response.setExtFields(ext);
        response.setBody(codes.encode(res));
        return response;
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

