/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoParticipant;
import org.apache.ozhera.app.api.model.HeraAppBaseQuery;
import org.apache.ozhera.app.api.model.HeraAppRoleModel;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.app.api.service.HeraAppService;
import org.apache.ozhera.app.common.Constant;
import org.apache.ozhera.app.dao.mapper.HeraAppBaseInfoMapper;
import org.apache.ozhera.app.dao.mapper.HeraAppExcessInfoMapper;
import org.apache.ozhera.app.dao.mapper.HeraAppRoleMapper;
import org.apache.ozhera.app.enums.StatusEnum;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.apache.ozhera.app.model.HeraAppExcessInfo;
import org.apache.ozhera.app.service.HeraAppRoleService;
import org.apache.ozhera.app.service.extension.AppTypeServiceExtension;
import org.apache.ozhera.app.service.impl.HeraAppBaseInfoService;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@org.apache.dubbo.config.annotation.Service(registry={"registryConfig"}, interfaceClass=HeraAppService.class, group="${dubbo.group}")
@Service
public class HeraAppServiceImpl
implements HeraAppService {
    private static final Logger log = LoggerFactory.getLogger(HeraAppServiceImpl.class);
    @Autowired
    HeraAppBaseInfoService heraAppBaseInfoService;
    private final HeraAppBaseInfoMapper heraAppBaseInfoMapper;
    private final HeraAppExcessInfoMapper heraAppExcessInfoMapper;
    private final HeraAppRoleService roleService;
    private final HeraAppRoleMapper heraAppRoleMapper;
    private final AppTypeServiceExtension appTypeServiceExtension;

    public HeraAppServiceImpl(HeraAppBaseInfoMapper heraAppBaseInfoMapper, HeraAppExcessInfoMapper heraAppExcessInfoMapper, HeraAppRoleService roleService, HeraAppRoleMapper heraAppRoleMapper, AppTypeServiceExtension appTypeServiceExtension) {
        this.heraAppBaseInfoMapper = heraAppBaseInfoMapper;
        this.heraAppExcessInfoMapper = heraAppExcessInfoMapper;
        this.roleService = roleService;
        this.heraAppRoleMapper = heraAppRoleMapper;
        this.appTypeServiceExtension = appTypeServiceExtension;
    }

    public List<AppBaseInfo> queryAppInfoWithLog(String appName, Integer type) {
        List<Object> appBaseInfos;
        Integer platformType = null;
        Integer appType = null;
        if (Objects.nonNull(type)) {
            appType = this.appTypeServiceExtension.getAppTypeLog(type);
            platformType = this.appTypeServiceExtension.getAppPlatForm(type);
        }
        if (CollectionUtils.isNotEmpty(appBaseInfos = this.heraAppBaseInfoMapper.queryAppInfo(appName, platformType, appType))) {
            appBaseInfos = appBaseInfos.parallelStream().map(appBaseInfo -> {
                appBaseInfo.setPlatformName(this.appTypeServiceExtension.getPlatformName(appBaseInfo.getPlatformType()));
                appBaseInfo.setAppTypeName(this.appTypeServiceExtension.getAppTypeName(appBaseInfo.getAppType()));
                return appBaseInfo;
            }).collect(Collectors.toList());
        }
        return appBaseInfos;
    }

    public List<AppBaseInfo> queryAllExistsApp() {
        return this.queryAppInfoWithLog("", null);
    }

    public AppBaseInfo queryById(Long id) {
        HeraAppBaseInfo heraAppBaseInfo = this.heraAppBaseInfoService.getById(id.intValue());
        if (null != heraAppBaseInfo) {
            return this.generateAppBaseInfo(heraAppBaseInfo);
        }
        return null;
    }

    public AppBaseInfo queryByIamTreeId(Long iamTreeId, String bingId, Integer platformType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"iam_tree_id", (Object)iamTreeId.intValue());
        if (StringUtils.isNotBlank((CharSequence)bingId)) {
            queryWrapper.eq((Object)"bind_id", (Object)bingId);
        }
        if (null != platformType) {
            queryWrapper.eq((Object)"platform_type", (Object)platformType);
        }
        queryWrapper.eq((Object)"status", (Object)StatusEnum.NOT_DELETED.getCode());
        List appBaseInfos = this.heraAppBaseInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)appBaseInfos)) {
            return this.generateAppBaseInfo((HeraAppBaseInfo)appBaseInfos.get(appBaseInfos.size() - 1));
        }
        return null;
    }

    public List<AppBaseInfo> queryByIds(List<Long> ids) {
        return this.heraAppBaseInfoMapper.queryByIds(ids);
    }

    public AppBaseInfo queryByAppId(Long appId, Integer type) {
        HeraAppBaseInfo heraAppBaseInfo;
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)StatusEnum.NOT_DELETED.getCode());
        queryWrapper.eq((Object)"bind_id", (Object)appId.toString());
        if (Objects.nonNull(type)) {
            Integer platformType = this.appTypeServiceExtension.getAppPlatForm(type);
            queryWrapper.eq((Object)"platform_type", (Object)platformType);
        }
        if (null != (heraAppBaseInfo = (HeraAppBaseInfo)this.heraAppBaseInfoMapper.selectOne((Wrapper)queryWrapper))) {
            return this.generateAppBaseInfo(heraAppBaseInfo);
        }
        return null;
    }

    public AppBaseInfo queryByAppIdPlatFormType(String bindId, Integer platformTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bind_id", (Object)bindId);
        queryWrapper.eq((Object)"platform_type", (Object)platformTypeCode);
        return this.getAppBaseInfo((QueryWrapper<HeraAppBaseInfo>)queryWrapper);
    }

    @Nullable
    private AppBaseInfo getAppBaseInfo(QueryWrapper<HeraAppBaseInfo> queryWrapper) {
        List appBaseInfos = this.heraAppBaseInfoMapper.selectList((Wrapper)queryWrapper);
        HeraAppBaseInfo heraAppBaseInfo = null;
        if (CollectionUtils.isNotEmpty((Collection)appBaseInfos)) {
            List baseInfos = appBaseInfos.stream().filter(appBaseInfo -> Objects.equals(StatusEnum.NOT_DELETED.getCode(), appBaseInfo.getStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(baseInfos)) {
                heraAppBaseInfo = (HeraAppBaseInfo)baseInfos.get(baseInfos.size() - 1);
            }
            if (null == heraAppBaseInfo) {
                heraAppBaseInfo = (HeraAppBaseInfo)appBaseInfos.get(appBaseInfos.size() - 1);
            }
            if (null != heraAppBaseInfo) {
                return this.generateAppBaseInfo(heraAppBaseInfo);
            }
        }
        return null;
    }

    public AppBaseInfo generateAppBaseInfo(HeraAppBaseInfo heraAppBaseInfo) {
        AppBaseInfo appBaseInfo = heraAppBaseInfo.toAppBaseInfo();
        HeraAppExcessInfo appExcessInfo = (HeraAppExcessInfo)this.heraAppExcessInfoMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"app_base_id", (Object)heraAppBaseInfo.getId()));
        if (null != appExcessInfo) {
            appBaseInfo.setNodeIPs(appExcessInfo.getNodeIPs());
            appBaseInfo.setTreeIds(appExcessInfo.getTreeIds());
        }
        Integer code = this.appTypeServiceExtension.getAppTypePlatformType(heraAppBaseInfo.getPlatformType());
        appBaseInfo.setPlatformType(code);
        appBaseInfo.setPlatformName(this.appTypeServiceExtension.getPlatformName(heraAppBaseInfo.getPlatformType()));
        appBaseInfo.setAppTypeName(this.appTypeServiceExtension.getAppTypeName(appBaseInfo.getAppType()));
        return appBaseInfo;
    }

    public Long countByParticipant(HeraAppBaseQuery query) {
        return this.heraAppBaseInfoService.countByParticipant(query);
    }

    public List<HeraAppBaseInfoParticipant> queryByParticipant(HeraAppBaseQuery query) {
        return this.heraAppBaseInfoService.queryByParticipant(query);
    }

    public Integer insertOrUpdate(HeraAppBaseInfoModel baseInfo) {
        HeraAppBaseInfo appBaseInfo = this.generateHeraAppBaseInfo(baseInfo);
        if (null != baseInfo.getId()) {
            return this.heraAppBaseInfoMapper.updateByPrimaryKey(appBaseInfo);
        }
        return this.heraAppBaseInfoMapper.insert(appBaseInfo);
    }

    private HeraAppBaseInfo generateHeraAppBaseInfo(HeraAppBaseInfoModel appBaseInfoModel) {
        HeraAppBaseInfo heraAppBaseInfo = new HeraAppBaseInfo();
        try {
            BeanUtils.copyProperties((Object)appBaseInfoModel, (Object)heraAppBaseInfo);
        }
        catch (Exception e) {
            log.error("getById copyProperties error,ori:{}", (Object)Constant.GSON.toJson((Object)appBaseInfoModel), (Object)e);
        }
        return heraAppBaseInfo;
    }

    public Long count(HeraAppBaseInfoModel baseInfo) {
        return this.heraAppBaseInfoService.count(baseInfo);
    }

    public List<HeraAppBaseInfoModel> query(HeraAppBaseInfoModel baseInfo, Integer pageCount, Integer pageNum) {
        ArrayList<HeraAppBaseInfoModel> list = new ArrayList<HeraAppBaseInfoModel>();
        List<HeraAppBaseInfo> query = this.heraAppBaseInfoService.query(baseInfo, pageCount, pageNum);
        if (CollectionUtils.isEmpty(query)) {
            return list;
        }
        query.forEach(t -> {
            HeraAppBaseInfoModel model = new HeraAppBaseInfoModel();
            BeanUtils.copyProperties((Object)t, (Object)model);
            list.add(model);
        });
        return list;
    }

    public HeraAppBaseInfoModel getById(Integer id) {
        HeraAppBaseInfo byId = this.heraAppBaseInfoService.getById(id);
        if (byId == null) {
            return null;
        }
        HeraAppBaseInfoModel model = new HeraAppBaseInfoModel();
        BeanUtils.copyProperties((Object)byId, (Object)model);
        return model;
    }

    public int delById(Integer id) {
        return this.heraAppBaseInfoService.delById(id);
    }

    public Long getAppCount() {
        return this.heraAppBaseInfoMapper.countNormalData();
    }

    public Integer delRoleById(Integer id) {
        return this.roleService.delById(id);
    }

    public Integer addRole(HeraAppRoleModel roleModel) {
        return this.roleService.addRole(roleModel);
    }

    public List<HeraAppRoleModel> queryRole(HeraAppRoleModel roleModel, Integer pageCount, Integer pageNum) {
        return this.roleService.query(roleModel, pageCount, pageNum);
    }

    public Long countRole(HeraAppRoleModel roleModel) {
        return this.roleService.count(roleModel);
    }

    public List<Long> userProjectIdAuth(String user, Long plateFormCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != plateFormCode) {
            queryWrapper.eq((Object)"app_platform", (Object)plateFormCode);
        }
        queryWrapper.eq((Object)"user", (Object)user);
        queryWrapper.select(new String[]{"app_id", "app_platform"});
        List appMonitors = this.heraAppRoleMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)appMonitors)) {
            return appMonitors.parallelStream().map(appMonitor -> {
                HeraAppBaseInfo heraAppIdByApp = this.getHeraAppIdByApp(Integer.valueOf(appMonitor.getAppId()), appMonitor.getAppPlatform());
                if (null != heraAppIdByApp) {
                    return heraAppIdByApp.getId().longValue();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private HeraAppBaseInfo getHeraAppIdByApp(Integer projectId, Integer plateFormCode) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(HeraAppBaseInfo::getBindId, (Object)projectId.toString())).eq(HeraAppBaseInfo::getStatus, (Object)StatusEnum.NOT_DELETED.getCode());
        lambdaQueryWrapper.eq(HeraAppBaseInfo::getPlatformType, (Object)plateFormCode);
        lambdaQueryWrapper.select(new SFunction[]{HeraAppBaseInfo::getId});
        List heraAppBaseInfos = this.heraAppBaseInfoMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)heraAppBaseInfos)) {
            return null;
        }
        return (HeraAppBaseInfo)heraAppBaseInfos.get(heraAppBaseInfos.size() - 1);
    }
}

