/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.app.common.Constant;
import org.apache.ozhera.app.dao.mapper.HeraAppBaseInfoMapper;
import org.apache.ozhera.app.dao.mapper.HeraAppEnvMapper;
import org.apache.ozhera.app.enums.OperateEnum;
import org.apache.ozhera.app.enums.StatusEnum;
import org.apache.ozhera.app.exception.AppException;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.apache.ozhera.app.model.HeraAppEnv;
import org.apache.ozhera.app.model.vo.HeraAppEnvVo;
import org.apache.ozhera.app.model.vo.HeraAppOperateVo;
import org.apache.ozhera.app.model.vo.HeraEnvIpVo;
import org.apache.ozhera.app.service.HeraAppEnvService;
import org.apache.ozhera.app.service.env.DefaultEnvIpFetch;
import org.apache.ozhera.app.service.env.EnvIpFetch;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class HeraAppEnvServiceImpl
implements HeraAppEnvService {
    private static final Logger log = LoggerFactory.getLogger(HeraAppEnvServiceImpl.class);
    private final HeraAppBaseInfoMapper heraAppBaseInfoMapper;
    private final HeraAppEnvMapper heraAppEnvMapper;
    private final DefaultEnvIpFetch defaultEnvIpFetch;
    private final DefaultMQProducer defaultMQProducer;
    private EnvIpFetch envIpFetch;
    @Value(value="${rocket.mq.hera.ip.change.topic}")
    private String ipChangeTopic;

    @PostConstruct
    public void init() {
        this.envIpFetch = this.defaultEnvIpFetch.getEnvIpFetch();
    }

    public HeraAppEnvServiceImpl(HeraAppEnvMapper heraAppEnvMapper, HeraAppBaseInfoMapper heraAppBaseInfoMapper, DefaultEnvIpFetch defaultEnvIpFetch, DefaultMQProducer defaultMQProducer) {
        this.heraAppEnvMapper = heraAppEnvMapper;
        this.heraAppBaseInfoMapper = heraAppBaseInfoMapper;
        this.defaultEnvIpFetch = defaultEnvIpFetch;
        this.defaultMQProducer = defaultMQProducer;
    }

    @Override
    public HeraAppEnvVo queryAppEnvById(Long id) {
        HeraAppEnv heraAppEnv = (HeraAppEnv)((Object)this.heraAppEnvMapper.selectById(id));
        if (null != heraAppEnv) {
            return heraAppEnv.toHeraAppEnvVo();
        }
        return null;
    }

    @Override
    public Long addAppEnv(HeraAppOperateVo operateVo) {
        HeraAppEnv heraAppEnv = new HeraAppEnv();
        heraAppEnv.operateVoToHeraAppEnv(operateVo, OperateEnum.ADD_OPERATE);
        this.heraAppEnvMapper.insert((Object)heraAppEnv);
        return heraAppEnv.getId();
    }

    @Override
    public Long updateAppEnv(HeraAppOperateVo operateVo) {
        if (null == this.heraAppEnvMapper.selectById(operateVo.getId())) {
            throw new AppException("\u5f53\u524d\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        HeraAppEnv heraAppEnv = new HeraAppEnv();
        heraAppEnv.operateVoToHeraAppEnv(operateVo, OperateEnum.UPDATE_OPERATE);
        this.heraAppEnvMapper.updateById((Object)heraAppEnv);
        return heraAppEnv.getId();
    }

    @Override
    public Boolean deleteAppEnv(Long id) {
        return this.heraAppEnvMapper.deleteById(id) == 1;
    }

    @Override
    public void fetchIpsOpByApp(String app) {
        int pageNum = 1;
        int pageSize = 100;
        while (true) {
            log.info("\u8f6e\u8be2\u5e94\u7528,pageNum:{},pageSize:{}", (Object)pageNum, (Object)pageSize);
            Page appBaseInfoPage = (Page)this.heraAppBaseInfoMapper.selectPage((IPage)new Page((long)pageNum, (long)pageSize), (Wrapper)new LambdaQueryWrapper().eq(HeraAppBaseInfo::getStatus, (Object)StatusEnum.NOT_DELETED.getCode()));
            List appBaseInfos = appBaseInfoPage.getRecords();
            if (CollectionUtils.isNotEmpty((Collection)appBaseInfos)) {
                appBaseInfos.stream().forEach(baseInfo -> {
                    Integer id = baseInfo.getId();
                    String bindId = baseInfo.getBindId();
                    String appName = baseInfo.getAppName();
                    try {
                        this.handleAppEnv(id, bindId, appName);
                    }
                    catch (Exception e) {
                        log.error(String.format("fetchIpsOpByApp job env ip info error,id:%d,bindId:%s,appName:%s", id, bindId, appName), (Throwable)e);
                    }
                });
            }
            if (null == appBaseInfoPage || !appBaseInfoPage.hasNext()) break;
            ++pageNum;
        }
    }

    public void handleAppEnv(Integer id, String bindId, String appName) throws Exception {
        this.envIpFetch = this.defaultEnvIpFetch.getEnvFetch(bindId);
        HeraAppEnvVo heraAppEnvVo = this.envIpFetch.fetch(id.longValue(), Long.valueOf(bindId), appName);
        log.debug("heraAppEnvVo,result:{}", (Object)Constant.GSON.toJson((Object)heraAppEnvVo));
        for (HeraAppEnvVo.EnvVo envVo : heraAppEnvVo.getEnvVos()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HeraAppEnv::getHeraAppId, (Object)id)).eq(HeraAppEnv::getAppId, (Object)Long.valueOf(bindId))).eq(HeraAppEnv::getEnvId, (Object)envVo.getEnvId());
            HeraAppEnv heraAppEnv = (HeraAppEnv)((Object)this.heraAppEnvMapper.selectOne((Wrapper)queryWrapper));
            if (null == heraAppEnv) {
                this.addAppEnvNotExist(heraAppEnvVo, envVo);
                return;
            }
            if (CollectionUtils.isEqualCollection(heraAppEnv.getIpList(), (Collection)envVo.getIpList())) continue;
            heraAppEnvVo.setId(heraAppEnv.getId());
            this.updateAppEnv(this.buildHeraAppOperateVo(heraAppEnvVo, envVo));
            this.publishIpChangeMq(this.buildHeraEnvIpVo(heraAppEnvVo, envVo));
        }
    }

    private void publishIpChangeMq(HeraEnvIpVo heraAppEnvVo) {
        String mqMessage = Constant.GSON.toJson((Object)heraAppEnvVo);
        log.info("mq data:{}", (Object)mqMessage);
        Message message = new Message();
        message.setTopic(this.ipChangeTopic);
        message.setBody(mqMessage.getBytes(StandardCharsets.UTF_8));
        try {
            this.defaultMQProducer.send(message);
            log.info("publish ip change MqMessage success");
        }
        catch (Exception e) {
            log.error("publish ip change MqMessage error,info:{}", (Object)mqMessage, (Object)e);
        }
    }

    @Override
    public void addAppEnvNotExist(HeraAppEnvVo heraAppEnvVo) {
        for (HeraAppEnvVo.EnvVo envVo : heraAppEnvVo.getEnvVos()) {
            this.addAppEnvNotExist(heraAppEnvVo, envVo);
        }
    }

    @Override
    public Boolean addAppEnvNotExist(HeraAppEnvVo heraAppEnvVo, HeraAppEnvVo.EnvVo envVo) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"hera_app_id", (Object)heraAppEnvVo.getHeraAppId())).eq((Object)"app_id", (Object)heraAppEnvVo.getAppId())).eq((Object)"env_id", (Object)envVo.getEnvId());
        HeraAppEnv heraAppEnv = (HeraAppEnv)((Object)this.heraAppEnvMapper.selectOne((Wrapper)queryWrapper));
        if (null == heraAppEnv) {
            this.addAppEnv(this.buildHeraAppOperateVo(heraAppEnvVo, envVo));
            return true;
        }
        return false;
    }

    @Override
    public List<String> queryNonProbeAccessIPs() {
        Page heraAppEnvPage;
        CopyOnWriteArrayList ipList = new CopyOnWriteArrayList();
        ConcurrentHashMap filterMap = new ConcurrentHashMap();
        long current = 1L;
        long size = 100L;
        do {
            Page page = new Page(current, size);
            heraAppEnvPage = (Page)this.heraAppEnvMapper.selectPage((IPage)page, (Wrapper)Wrappers.emptyWrapper());
            List pageRecords = heraAppEnvPage.getRecords();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (HeraAppEnv heraAppEnv : pageRecords) {
                futures.add(CompletableFuture.runAsync(() -> this.processHeraAppEnv(heraAppEnv, filterMap, ipList)));
            }
            CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            allOf.join();
            ++current;
        } while (heraAppEnvPage.hasNext());
        return ipList.parallelStream().distinct().collect(Collectors.toList());
    }

    private void processHeraAppEnv(HeraAppEnv heraAppEnv, Map<Long, Boolean> filterMap, List<String> ipList) {
        if (filterMap.containsKey(heraAppEnv.getAppId()) && filterMap.get(heraAppEnv.getAppId()).booleanValue()) {
            ipList.addAll(heraAppEnv.getIpList());
        } else {
            EnvIpFetch envFetchFromRemote = this.defaultEnvIpFetch.getEnvFetchFromRemote(heraAppEnv.getAppId().toString());
            if (envFetchFromRemote != null) {
                ipList.addAll(heraAppEnv.getIpList());
            }
            filterMap.put(heraAppEnv.getAppId(), envFetchFromRemote != null);
        }
    }

    private HeraAppOperateVo buildHeraAppOperateVo(HeraAppEnvVo heraAppEnvVo, HeraAppEnvVo.EnvVo envVo) {
        HeraAppOperateVo heraAppOperateVo = new HeraAppOperateVo();
        BeanUtils.copyProperties((Object)heraAppEnvVo, (Object)heraAppOperateVo);
        heraAppOperateVo.setEnvId(envVo.getEnvId());
        heraAppOperateVo.setEnvName(envVo.getEnvName());
        heraAppOperateVo.setIpList(envVo.getIpList());
        heraAppOperateVo.setOperator(Constant.DEFAULT_OPERATOR);
        return heraAppOperateVo;
    }

    private HeraEnvIpVo buildHeraEnvIpVo(HeraAppEnvVo heraAppEnvVo, HeraAppEnvVo.EnvVo envVo) {
        HeraEnvIpVo heraEnvIpVo = new HeraEnvIpVo();
        BeanUtils.copyProperties((Object)heraAppEnvVo, (Object)heraEnvIpVo);
        BeanUtils.copyProperties((Object)envVo, (Object)heraEnvIpVo);
        return heraEnvIpVo;
    }
}

