/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.dao;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.common.Constant;
import org.apache.ozhera.app.dao.mapper.HeraProjectGroupUserMapper;
import org.apache.ozhera.app.model.HeraProjectGroupUser;
import org.apache.ozhera.app.model.HeraProjectGroupUserExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class HeraProjectGroupUserDao {
    private static final Logger log = LoggerFactory.getLogger(HeraProjectGroupUserDao.class);
    @Resource
    private HeraProjectGroupUserMapper projectGroupUserMapper;

    public List<Integer> listGroupIdsByUser(String user) {
        if (StringUtils.isBlank((CharSequence)user)) {
            return null;
        }
        HeraProjectGroupUserExample example = new HeraProjectGroupUserExample();
        HeraProjectGroupUserExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(0);
        ca.andUserEqualTo(user);
        example.setOffset(0);
        example.setLimit(Integer.MAX_VALUE);
        List<HeraProjectGroupUser> heraProjectGroupUsers = null;
        try {
            heraProjectGroupUsers = this.projectGroupUserMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("HeraProjectGroupUserDao#listGroupIdsByUser error! exception:{}", (Object)e.getMessage(), (Object)e);
        }
        if (CollectionUtils.isEmpty(heraProjectGroupUsers)) {
            log.info("listGroupIdsByUser no data found!user:{}", (Object)user);
            return null;
        }
        return heraProjectGroupUsers.stream().map(t -> t.getProjectGroupId()).collect(Collectors.toList());
    }

    public List<HeraProjectGroupUser> listByProjectGroupId(Integer projectGroupId) {
        if (projectGroupId == null) {
            log.error("listByProjectGroupId param is invalid!");
            return null;
        }
        HeraProjectGroupUserExample example = new HeraProjectGroupUserExample();
        HeraProjectGroupUserExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(0);
        ca.andProjectGroupIdEqualTo(projectGroupId);
        example.setOffset(1);
        example.setLimit(Integer.MAX_VALUE);
        List<HeraProjectGroupUser> heraProjectGroupUsers = null;
        try {
            heraProjectGroupUsers = this.projectGroupUserMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("HeraProjectGroupUserDao#listGroupIdsByUser error! exception:{}", (Object)e.getMessage(), (Object)e);
        }
        return heraProjectGroupUsers;
    }

    public Integer batchInsert(List<HeraProjectGroupUser> users) {
        try {
            if (CollectionUtils.isEmpty(users)) {
                return 0;
            }
            return this.projectGroupUserMapper.batchInsert(users);
        }
        catch (Exception e) {
            log.error("batchInsert error!exception : {},userInfos : {}", new Object[]{e.getMessage(), Constant.GSON.toJson(users), e});
            return 0;
        }
    }

    public Integer delById(Integer id) {
        try {
            return this.projectGroupUserMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            log.error("delById error!exception : {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    public Integer delByGroupId(Integer groupId) {
        HeraProjectGroupUserExample example = new HeraProjectGroupUserExample();
        HeraProjectGroupUserExample.Criteria ca = example.createCriteria();
        ca.andProjectGroupIdEqualTo(groupId);
        try {
            return this.projectGroupUserMapper.deleteByExample(example);
        }
        catch (Exception e) {
            log.error("delByGroupId error!exception : {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }
}

