/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.xiaomi.data.push.client.HttpClientV2;
import com.xiaomi.data.push.common.Result;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.common.Safe;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.datasource.DatasourceConfig;
import com.xiaomi.youpin.docean.plugin.datasource.DatasourceMeta;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin(order=10)
public class DatasourcePlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(DatasourcePlugin.class);
    public static final String PREFIX = "ds_";
    public static final String DB_NAMES = "DB_NAMES";
    private static final String DB_DS_NAME = "db_ds_name";
    private static final String GATEWAY_HOST = "mi_gateway_host";
    private static final String GET_DS_URI = "/mtop/arch/plugin/datasource/getDsByNames";

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        log.info("init datasource plugin");
        ArrayList dbNames = new ArrayList();
        Config c = (Config)ioc.getBean(Config.class);
        this.initByConfig(ioc, c, dbNames);
        this.initByDsNames(ioc, c, dbNames);
        ioc.putBean(DB_NAMES, dbNames);
    }

    private void initByConfig(Ioc ioc, Config c, List dbNames) {
        String dsType = c.get("ds_type", "");
        if (StringUtils.isNotEmpty((String)c.get("db_url", ""))) {
            String dbName = c.get("db_name", "ds_0");
            DatasourceConfig dsConfig = this.generateDatasourceConfig("", c);
            ioc.putBean(dbName, (Object)this.dataSource(dsConfig, dsType));
            ioc.putBean(dbName + "_config", (Object)dsConfig);
            dbNames.add(dbName);
        } else {
            Map dbConfMap = c.getByPrefix(PREFIX, false);
            Set dbGroupSet = dbConfMap.keySet().stream().map(k -> {
                if (k.indexOf(".") < 0) {
                    return null;
                }
                String groupKey = k.substring(0, k.indexOf("."));
                return groupKey;
            }).filter(k -> k != null).collect(Collectors.toSet());
            dbGroupSet.stream().forEach(groupKey -> {
                String prefix = groupKey + ".";
                if (StringUtils.isNotEmpty((String)c.get(prefix + "db_url", ""))) {
                    String dbName = c.get(prefix + "db_name", groupKey);
                    DatasourceConfig dsConfig = this.generateDatasourceConfig(prefix, c);
                    ioc.putBean(dbName, (Object)this.dataSource(dsConfig, dsType));
                    ioc.putBean(dbName + "_config", (Object)dsConfig);
                    dbNames.add(dbName);
                }
            });
        }
    }

    private void initByDsNames(Ioc ioc, Config c, List dbNames) {
        List<DatasourceMeta> extendDsList = this.getDsByNames(c);
        if (null == extendDsList || extendDsList.size() == 0) {
            return;
        }
        extendDsList.forEach(datasourceMeta -> {
            String dbName = datasourceMeta.getName();
            if (!dbNames.contains(dbName)) {
                DatasourceConfig dsConfig = this.generateDatasourceConfig((DatasourceMeta)datasourceMeta);
                ioc.putBean(dbName, (Object)this.dataSource(dsConfig));
                ioc.putBean(dbName + "_config", (Object)dsConfig);
                dbNames.add(dbName);
            }
        });
    }

    private List<DatasourceMeta> getDsByNames(Config config) {
        String dbNames = config.get(DB_DS_NAME, "");
        if (StringUtils.isBlank((String)dbNames)) {
            return Lists.newArrayList();
        }
        String gatewayHost = config.get(GATEWAY_HOST, "");
        if (StringUtils.isBlank((String)gatewayHost)) {
            throw new RuntimeException(String.format("init datasource by %s:%s failed, config \"%s\" can not be null", DB_DS_NAME, dbNames, GATEWAY_HOST));
        }
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("names", Arrays.asList(dbNames.split(",")));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Yp-App-Token", "9z5ThYv4hZJco99Xds7W");
        String dbNamesContent = HttpClientV2.post((String)(gatewayHost + GET_DS_URI), (String)("[" + new Gson().toJson(body) + "]"), headers);
        if (StringUtils.isBlank((String)dbNamesContent)) {
            return Lists.newArrayList();
        }
        Result result = (Result)new Gson().fromJson(dbNamesContent, new TypeToken<Result<List<DatasourceMeta>>>(this){}.getType());
        List datasourceMetaList = (List)result.getData();
        return datasourceMetaList;
    }

    public void remove(DatasourceConfig config) {
        ComboPooledDataSource ds = (ComboPooledDataSource)Ioc.ins().getBean("ds:" + config.getName());
        ds.close();
        Ioc.ins().remove("ds:" + config.getName());
    }

    public DataSource add(DatasourceConfig config) {
        DataSource ds = this.dataSource(config);
        Ioc.ins().putBean("ds:" + config.getName(), (Object)ds);
        return ds;
    }

    private DatasourceConfig generateDatasourceConfig(String prefix, Config c) {
        DatasourceConfig config = new DatasourceConfig();
        config.setName(c.get(prefix + "db_name", ""));
        config.setDataSourcePasswd(c.get(prefix + "db_pwd", ""));
        config.setDataSourceUrl(c.get(prefix + "db_url", ""));
        config.setDataSourceUserName(c.get(prefix + "db_user_name", ""));
        config.setDefaultInitialPoolSize(Integer.valueOf(c.get(prefix + "db_pool_size", "1")));
        config.setDefaultMaxPoolSize(Integer.valueOf(c.get(prefix + "db_pool_size", "1")));
        config.setDefaultMinPoolSize(Integer.valueOf(c.get(prefix + "db_pool_size", "1")));
        config.setDriverClass(c.get(prefix + "db_driver", "com.mysql.jdbc.Driver"));
        return config;
    }

    private DatasourceConfig generateDatasourceConfig(DatasourceMeta datasourceMeta) {
        DatasourceConfig config = new DatasourceConfig();
        config.setName(datasourceMeta.getName());
        config.setDataSourcePasswd(datasourceMeta.getPassWd());
        config.setDataSourceUrl(datasourceMeta.getDataSourceUrl());
        config.setDataSourceUserName(datasourceMeta.getUserName());
        config.setDefaultInitialPoolSize(0 == datasourceMeta.getPoolSize() ? 1 : datasourceMeta.getPoolSize());
        config.setDefaultMaxPoolSize(0 == datasourceMeta.getMaxPoolSize() ? 1 : datasourceMeta.getMaxPoolSize());
        config.setDefaultMinPoolSize(0 == datasourceMeta.getMinPoolSize() ? 1 : datasourceMeta.getMinPoolSize());
        config.setDriverClass(datasourceMeta.getDriverClass());
        return config;
    }

    private DataSource dataSource(DatasourceConfig config) {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(config.getDriverClass());
        dataSource.setJdbcUrl(config.getDataSourceUrl());
        dataSource.setUser(config.getDataSourceUserName());
        dataSource.setPassword(config.getDataSourcePasswd());
        dataSource.setInitialPoolSize(config.getDefaultInitialPoolSize().intValue());
        dataSource.setMaxPoolSize(config.getDefaultMaxPoolSize().intValue());
        dataSource.setMinPoolSize(config.getDefaultMinPoolSize().intValue());
        this.initComboPooledDatasouce(dataSource);
        return dataSource;
    }

    private DataSource dataSource(DatasourceConfig c, String type) {
        if (type.equals("hikari")) {
            log.info("use hikari ds");
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(c.getDataSourceUrl());
            config.setUsername(c.getDataSourceUserName());
            config.setPassword(c.getDataSourcePasswd());
            config.setDriverClassName(c.getDriverClass());
            config.addDataSourceProperty("cachePrepStmts", (Object)"true");
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            config.setMinimumIdle(c.getDefaultMinPoolSize().intValue());
            config.setMaximumPoolSize(c.getDefaultMaxPoolSize().intValue());
            return new HikariDataSource(config);
        }
        if (type.equals("druid")) {
            log.info("use druid ds");
            DruidDataSource datasource = new DruidDataSource();
            datasource.setUrl(c.getDataSourceUrl());
            datasource.setUsername(c.getDataSourceUserName());
            datasource.setPassword(c.getDataSourcePasswd());
            datasource.setDriverClassName(c.getDriverClass());
            datasource.setInitialSize(c.getDefaultInitialPoolSize().intValue());
            datasource.setMinIdle(c.getDefaultMinPoolSize().intValue());
            datasource.setMaxActive(c.getDefaultMaxPoolSize().intValue());
        }
        return this.dataSource(c);
    }

    private void initComboPooledDatasouce(ComboPooledDataSource dataSource) {
        log.info("init c3p0 datasource");
        dataSource.setTestConnectionOnCheckin(true);
        dataSource.setTestConnectionOnCheckout(true);
        dataSource.setPreferredTestQuery("select 1");
        dataSource.setMaxIdleTime(180);
        dataSource.setIdleConnectionTestPeriod(60);
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(() -> Safe.run(() -> log.debug("datasource info NumConnections:{} NumBusyConnections:{} NumIdleConnections:{} NumUnclosedOrphanedConnections:{}", new Object[]{dataSource.getNumConnectionsDefaultUser(), dataSource.getNumBusyConnectionsDefaultUser(), dataSource.getNumIdleConnectionsDefaultUser(), dataSource.getNumUnclosedOrphanedConnectionsDefaultUser()})), 0L, 5L, TimeUnit.MINUTES);
    }

    public String version() {
        return "0.0.1:goodjava@qq.com:20210829";
    }
}

