/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String LoadFile(String path) {
        lock.lock();
        try {
            String content;
            log.info("FileUtil LoadFile path: {}", (Object)path);
            File file = new File(path);
            if (!file.exists() || !FileUtil.isCanReadFile(file)) {
                String string = "";
                return string;
            }
            String string = content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String WriteFile(String path, String content) {
        lock.lock();
        try {
            log.info("FileUtil WriteFile path: {}", (Object)path);
            File file = new File(path);
            if (!file.exists() || !FileUtil.isCanWriteFile(file)) {
                String string = "";
                return string;
            }
            if (path.equals("/usr/local/etc/prometheus.yml")) {
                log.info("checkNullFile path: {},content: {}", (Object)path, (Object)content);
            }
            FileUtils.write((File)file, (CharSequence)content);
            String string = "success";
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AppendWriteFile(String path, String content) {
        lock.lock();
        try {
            FileWriter fileWriter = new FileWriter(path, true);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(content);
            printWriter.close();
            fileWriter.close();
            log.info("AppendWriteFile path success : {}", (Object)path);
        }
        catch (IOException e) {
            log.error("AppendWriteFile path :{} error : {}", (Object)path, (Object)e.getMessage());
        }
        finally {
            lock.unlock();
        }
    }

    public static boolean IsHaveFile(String path) {
        log.info("FileUtil IsHaveFile path: {}", (Object)path);
        File file = new File(path);
        return file.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkAndReadFile(String path) {
        lock.lock();
        try {
            log.info("FileUtil checkAndReadFile path: {}", (Object)path);
            File file = new File(path);
            if (!file.exists()) {
                String string = "not exist";
                return string;
            }
            if (!FileUtil.isCanReadFile(file)) {
                String string = "";
                return string;
            }
            String string = FileUtils.readFileToString((File)file, (String)"UTF-8");
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DeleteFile(String path) {
        lock.lock();
        try {
            boolean delete;
            log.info("FileUtil DeleteFile path: {}", (Object)path);
            File file = new File(path);
            boolean bl = delete = file.delete();
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            lock.unlock();
            throw throwable;
        }
    }

    private static boolean isCanReadFile(File file) {
        log.info("FileUtil isCanReadFile file: {}", (Object)file.getAbsoluteFile());
        return file.canRead();
    }

    private static boolean isCanWriteFile(File file) {
        log.info("FileUtil isCanWriteFile file: {}", (Object)file.getAbsoluteFile());
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean RenameFile(String oldPath, String newPath) {
        lock.lock();
        try {
            boolean res;
            log.info("FileUtil RenameFile oldPath: {},newPath: {}", (Object)oldPath, (Object)newPath);
            File file = new File(oldPath);
            if (!file.exists()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = res = file.renameTo(new File(newPath));
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GenerateFile(String path) {
        lock.lock();
        try {
            log.info("FileUtil GenerateFile path: {}", (Object)path);
            File file = new File(path);
            if (!file.exists()) {
                File parentDir = file.getParentFile();
                if (!parentDir.exists()) {
                    boolean dirsCreated = parentDir.mkdirs();
                    log.info("FileUtil GenerateFile parentDir created: {}", (Object)dirsCreated);
                }
                boolean newFile = file.createNewFile();
                log.info("FileUtil GenerateFile newFile: {}", (Object)newFile);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

