/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.webhook.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.webhook.common.HttpClientUtil;
import org.apache.ozhera.webhook.domain.JsonPatch;
import org.apache.ozhera.webhook.domain.k8s.Container;
import org.apache.ozhera.webhook.domain.k8s.Limits;
import org.apache.ozhera.webhook.domain.k8s.Requests;
import org.apache.ozhera.webhook.domain.k8s.Resource;
import org.apache.ozhera.webhook.domain.k8s.VolumeMount;
import org.apache.ozhera.webhook.domain.tpc.TpcAppInfo;
import org.apache.ozhera.webhook.domain.tpc.TpcAppRequest;
import org.apache.ozhera.webhook.domain.tpc.TpcEnvRequest;
import org.apache.ozhera.webhook.service.HeraWebhookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HeraWebhookServiceImpl
implements HeraWebhookService {
    private static final Logger log = LoggerFactory.getLogger(HeraWebhookServiceImpl.class);
    private static final String HOST_IP = "host.ip";
    private static final String NODE_IP = "node.ip";
    private static final String MIONE_PROJECT_ENV_NAME = "MIONE_PROJECT_ENV_NAME";
    private static final String MIONE_PROJECT_NAME = "MIONE_PROJECT_NAME";
    private static final String MIONE_PROJECT_ENV_ID = "MIONE_PROJECT_ENV_ID";
    private static final String APPLICATION = "application";
    private static final String SERVER_ENV = "serverEnv";
    private static final String POD_IP_CAD = "POD_IP";
    private static final String NODE_IP_CAD = "NODE_IP";
    private static final Cache<String, TpcAppInfo> CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(Duration.ofMinutes(10L)).build();
    private static final String TPC_NODE_LIST_PATH = "/backend/node/inner_list";
    private static final Map<String, String> TPC_HEADER = new HashMap<String, String>();
    private final List<String> logAgentConditionNameSpaceLists = new ArrayList<String>();
    private final List<String> podPrefixesLists = new ArrayList<String>();
    private final List<String> logAgentVolumeMountNameList = new ArrayList<String>();
    private static final String LOG_AGENT_NACOS_ENV_KEY = "nacosAddr";
    @NacosValue(value="${tpc.url}")
    private String TPC_URL;
    @NacosValue(value="${tpc.token}")
    private String TPC_TOKEN;
    @NacosValue(value="${tpc.pageSize}")
    private String tpcPageSize;
    @NacosValue(value="${app.key.name}")
    private String appKeyName;
    @NacosValue(value="${app.key.type}")
    private String appKeyType;
    @NacosValue(value="${env.key.name}")
    private String envKeyName;
    @NacosValue(value="${env.key.type}")
    private String envKeyType;
    @NacosValue(value="${log.agent.condition.namespace}")
    private String logAgentConditionNamespace;
    @NacosValue(value="${log.agent.volume.mount.name}")
    private String logAgentVolumeMountName;
    @NacosValue(value="${log.agent.pod.prefix}")
    private String podPrefixes;
    @NacosValue(value="${log.agent.container.name}")
    private String logAgentContainerName;
    @NacosValue(value="${log.agent.container.image}")
    private String logAgentContainerImage;
    @NacosValue(value="${log.agent.container.cpu.limit}")
    private String logAgentContainerCpuLimit;
    @NacosValue(value="${log.agent.container.mem.limit}")
    private String logAgentContainerMemLimit;
    @NacosValue(value="${log.agent.nacos.addr}")
    private String logAgentNacosAddr;

    @Override
    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((CharSequence)this.appKeyType)) {
            this.appKeyType = "label";
        }
        if (StringUtils.isEmpty((CharSequence)this.appKeyName)) {
            this.appKeyName = "app";
        }
        if (StringUtils.isEmpty((CharSequence)this.envKeyType)) {
            this.envKeyType = "label";
        }
        if (StringUtils.isEmpty((CharSequence)this.envKeyName)) {
            this.envKeyName = SERVER_ENV;
        }
        if (StringUtils.isEmpty((CharSequence)this.logAgentConditionNamespace)) {
            this.logAgentConditionNamespace = "ozhera-namespace";
        }
        if (StringUtils.isEmpty((CharSequence)this.logAgentVolumeMountName)) {
            this.logAgentVolumeMountName = "log-path";
        }
        if (StringUtils.isEmpty((CharSequence)this.podPrefixes)) {
            this.podPrefixes = "hera-demo,otel-go,mimeter";
        }
        if (StringUtils.isEmpty((CharSequence)this.logAgentContainerName)) {
            this.logAgentContainerName = "log-agent";
        }
        if (StringUtils.isEmpty((CharSequence)this.logAgentContainerImage)) {
            this.logAgentContainerImage = "herahub/opensource-pub:log-agent-v1.2.8";
        }
        if (StringUtils.isEmpty((CharSequence)this.logAgentContainerCpuLimit)) {
            this.logAgentContainerCpuLimit = "1";
        }
        if (StringUtils.isEmpty((CharSequence)this.logAgentContainerMemLimit)) {
            this.logAgentContainerMemLimit = "2Gi";
        }
        if (StringUtils.isEmpty((CharSequence)this.logAgentNacosAddr)) {
            this.logAgentNacosAddr = "nacos:80";
        }
        if (StringUtils.isEmpty((CharSequence)this.TPC_URL)) {
            this.TPC_URL = "http://mi-tpc:8097/backend/node/inner_list";
        }
        if (StringUtils.isEmpty((CharSequence)this.tpcPageSize)) {
            this.tpcPageSize = "100";
        }
        if (StringUtils.isEmpty((CharSequence)this.TPC_TOKEN)) {
            log.info("TPC_TOKEN is empty, and return");
            return;
        }
        TPC_HEADER.put("Content-Type", "application/json");
        this.logAgentConditionNameSpaceLists.addAll(Arrays.asList(this.logAgentConditionNamespace.split(",")));
        this.podPrefixesLists.addAll(Arrays.asList(this.podPrefixes.split(",")));
        this.logAgentVolumeMountNameList.addAll(Arrays.asList(this.logAgentVolumeMountName.split(",")));
    }

    @Override
    public List<JsonPatch> setPodEnv(JSONObject admissionRequest) {
        if (!this.includeNameSpace(admissionRequest.getString("namespace"))) {
            log.warn("setPodEnv name space is invalid");
            return null;
        }
        if (!this.filterByPodName(admissionRequest)) {
            log.warn("setPodEnv pod name prefix is invalid");
            return null;
        }
        String operation = admissionRequest.getString("operation");
        if (!"CREATE".equals(operation)) {
            log.warn("setPodEnv operator is invalid");
            return null;
        }
        ArrayList<JsonPatch> result = new ArrayList<JsonPatch>();
        String appValueByAppKeyType = this.getAppValueByAppKeyType(admissionRequest);
        String envValueByEnvKeyType = this.getEnvValueByEnvKeyType(admissionRequest);
        JSONArray containersJson = admissionRequest.getJSONObject("object").getJSONObject("spec").getJSONArray("containers");
        for (int i = 0; i < containersJson.size(); ++i) {
            this.innerDealPodEnv(containersJson, i, result, appValueByAppKeyType, envValueByEnvKeyType);
        }
        return result;
    }

    @Override
    public void setLogAgent(JSONObject admissionRequest, List<JsonPatch> jsonPatches) {
        if (!this.includeNameSpace(admissionRequest.getString("namespace"))) {
            log.warn("setLogAgent name space is invalid");
            return;
        }
        if (!this.filterByPodName(admissionRequest)) {
            log.warn("setLogAgent pod name prefix is invalid");
            return;
        }
        JSONArray containersJson = admissionRequest.getJSONObject("object").getJSONObject("spec").getJSONArray("containers");
        if (containersJson == null || containersJson.isEmpty()) {
            log.warn("setLogAgent container is null");
            return;
        }
        JSONObject container = containersJson.getJSONObject(0);
        if (!this.includeVolumeMounts(container)) {
            log.warn("setLogAgent volume mounts is invalid");
            return;
        }
        String operation = admissionRequest.getString("operation");
        if (!"CREATE".equals(operation)) {
            log.warn("setLogAgent operation is invalid");
            return;
        }
        for (int i = 0; i < containersJson.size(); ++i) {
            if (!this.logAgentContainerName.equals(containersJson.getJSONObject(i).getString("name"))) continue;
            return;
        }
        ArrayList<EnvVar> envs = new ArrayList<EnvVar>();
        VolumeMount volumeMount = this.getVolumeMountAndAddEnv(container, envs, admissionRequest.getString("name"));
        if (volumeMount == null) {
            log.warn("setLogAgent volume mounts is null");
            return;
        }
        this.buildLogAgentContainer(volumeMount, envs, jsonPatches);
    }

    private void innerDealPodEnv(JSONArray containersJson, int i, List<JsonPatch> result, String appLabelValue, String envLabelValue) {
        JSONObject container = containersJson.getJSONObject(i);
        String envBasePath = "/spec/containers/" + i + "/env";
        if (container != null) {
            JSONArray env = container.getJSONArray("env");
            if (env == null) {
                String path = "/spec/containers/" + i + "/env";
                ArrayList<EnvVar> envs = new ArrayList<EnvVar>();
                envs.add(this.createPodIdEnv());
                envs.add(this.createNodeIdEnv());
                envs.add(this.createPodIpCADEnv());
                envs.add(this.createNodeIpCADEnv());
                result.add(new JsonPatch("add", envBasePath, envs));
            } else {
                Set<String> envKeys = this.envKeys(env);
                String path = envBasePath + "/-";
                this.addIfAbsent(result, path, HOST_IP, this.createPodIdEnv(), envKeys);
                this.addIfAbsent(result, path, NODE_IP, this.createNodeIdEnv(), envKeys);
                this.addIfAbsent(result, path, POD_IP_CAD, this.createPodIpCADEnv(), envKeys);
                this.addIfAbsent(result, path, NODE_IP_CAD, this.createNodeIpCADEnv(), envKeys);
                TpcAppInfo appInfo = this.getAppInfo(env, appLabelValue, envLabelValue);
                if (appInfo != null) {
                    this.setOzHeraEnvs(result, path, appInfo, envKeys);
                }
            }
        }
    }

    private EnvVar createPodIdEnv() {
        return this.buildEnvRef(HOST_IP, "v1", "status.podIP");
    }

    private EnvVar createNodeIdEnv() {
        return this.buildEnvRef(NODE_IP, "v1", "status.hostIP");
    }

    private EnvVar createPodIpCADEnv() {
        return this.buildEnvRef(POD_IP_CAD, "v1", "status.podIP");
    }

    private EnvVar createNodeIpCADEnv() {
        return this.buildEnvRef(NODE_IP_CAD, "v1", "status.hostIP");
    }

    private void addIfAbsent(List<JsonPatch> result, String path, String key, EnvVar envVar, Set<String> envKeys) {
        if (!envKeys.contains(key)) {
            result.add(new JsonPatch<EnvVar>("add", path, envVar));
        }
    }

    private String getLabelValue(String key, JSONObject labelsJson) {
        if (StringUtils.isNotEmpty((CharSequence)key) && labelsJson != null && !labelsJson.isEmpty()) {
            return labelsJson.getString(key);
        }
        return null;
    }

    private EnvVar buildEnv(String key, String value) {
        EnvVar env = new EnvVar();
        env.setName(key);
        env.setValue(value);
        return env;
    }

    private EnvVar buildEnvRef(String key, String apiVersion, String fieldPath) {
        EnvVar env = new EnvVar();
        env.setName(key);
        EnvVarSource envVarSource = new EnvVarSource();
        ObjectFieldSelector objectFieldSelector = new ObjectFieldSelector();
        objectFieldSelector.setApiVersion(apiVersion);
        objectFieldSelector.setFieldPath(fieldPath);
        envVarSource.setFieldRef(objectFieldSelector);
        env.setValueFrom(envVarSource);
        return env;
    }

    private Set<String> envKeys(JSONArray envs) {
        HashSet<String> keySet = new HashSet<String>();
        if (envs != null && envs.size() > 0) {
            for (int i = 0; i < envs.size(); ++i) {
                keySet.add(envs.getJSONObject(i).getString("name"));
            }
        }
        return keySet;
    }

    private TpcAppInfo getAppInfo(JSONArray envs, String appLabelValue, String envLabelValue) {
        log.info("HeraWebhook:getAppInfo appLabelValue:{}envLabelValue:{}", (Object)appLabelValue, (Object)envLabelValue);
        if (StringUtils.isNotEmpty((CharSequence)appLabelValue)) {
            TpcAppInfo appInfo = (TpcAppInfo)CACHE.asMap().get(appLabelValue);
            if (appInfo == null) {
                appInfo = new TpcAppInfo();
                this.getAppIdFromTpc(appInfo, appLabelValue);
                if (appInfo.getId() == null) {
                    return null;
                }
                this.getEnvFromTpc(appInfo, envLabelValue);
                CACHE.put((Object)appLabelValue, (Object)appInfo);
            } else {
                log.warn("K8S_ENV or K8S_APP_COUNTRY or K8S_SERVICE");
            }
            return appInfo;
        }
        return null;
    }

    private String getEnv(JSONArray envs, String envKey) {
        if (envs != null && StringUtils.isNotEmpty((CharSequence)envKey)) {
            for (int i = 0; i < envs.size(); ++i) {
                JSONObject envJson = envs.getJSONObject(i);
                if (!envKey.equals(envJson.getString("name"))) continue;
                return envJson.getString("value");
            }
        }
        return null;
    }

    private void getAppIdFromTpc(TpcAppInfo appInfo, String appLabelValue) {
        TpcAppRequest tpcAppRequest = new TpcAppRequest();
        tpcAppRequest.setType(4);
        tpcAppRequest.setStatus(0);
        tpcAppRequest.setToken(this.TPC_TOKEN);
        tpcAppRequest.setNodeName(appLabelValue);
        if (!StringUtils.isEmpty((CharSequence)this.tpcPageSize)) {
            tpcAppRequest.setPageSize(this.tpcPageSize);
        }
        String tpcAppRequestBody = JSON.toJSONString((Object)tpcAppRequest);
        log.info("HeraWebhookService.getAppIdFromTpc.Request:{}", (Object)tpcAppRequestBody);
        try {
            String resp = HttpClientUtil.sendPostRequest(this.TPC_URL, tpcAppRequestBody, TPC_HEADER);
            log.info("HeraWebhookService.getAppIdFromTpc.Res:{}", (Object)resp);
            if (StringUtils.isEmpty((CharSequence)resp)) {
                return;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)resp);
            Integer code = jsonObject.getInteger("code");
            if (code == null || code != 0) {
                return;
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (data == null) {
                return;
            }
            JSONArray list = data.getJSONArray("list");
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Long appId;
                JSONObject node = list.getJSONObject(i);
                Long id = node.getLongValue("id");
                Long outId = node.getLongValue("outId");
                String nodeName = node.getString("nodeName");
                if (id == 0L || StringUtils.isEmpty((CharSequence)nodeName)) {
                    log.warn("get appName from tpc is null\uff0cnode\uff1a{}", (Object)node);
                    continue;
                }
                Long l = appId = outId == 0L ? id : outId;
                if (!appLabelValue.equals(nodeName)) continue;
                appInfo.setId(id);
                appInfo.setOutId(outId);
                appInfo.setName(appLabelValue);
                appInfo.setIdAndName(appId + "-" + appLabelValue);
                return;
            }
        }
        catch (Exception e) {
            log.error("get appName parse tpc resp error, ", (Throwable)e);
        }
    }

    private void getEnvFromTpc(TpcAppInfo tpcAppInfo, String envLabelValue) {
        TpcEnvRequest tpcEnvRequest = new TpcEnvRequest();
        tpcEnvRequest.setParentId(tpcAppInfo.getId());
        tpcEnvRequest.setType(6);
        tpcEnvRequest.setStatus(0);
        tpcEnvRequest.setToken(this.TPC_TOKEN);
        String envBody = JSON.toJSONString((Object)tpcEnvRequest);
        try {
            log.info("HeraWebhookService.getEnvFromTpc.Request:{}", (Object)tpcEnvRequest);
            String resp = HttpClientUtil.sendPostRequest(this.TPC_URL, envBody, TPC_HEADER);
            log.info("HeraWebhookService.getEnvFromTpc.Res:{}", (Object)resp);
            if (StringUtils.isEmpty((CharSequence)resp)) {
                return;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)resp);
            Integer code = jsonObject.getInteger("code");
            if (code == null || code != 0) {
                return;
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (data == null) {
                return;
            }
            JSONArray list = data.getJSONArray("list");
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                JSONObject node = list.getJSONObject(i);
                Long envId = node.getLong("id");
                String envName = node.getString("nodeName");
                if (envId == null || envId == 0L || StringUtils.isEmpty((CharSequence)envName)) {
                    log.warn("get env from tpc is null\uff0cenvId\uff1a{}\uff0cenvName\uff1a{}", (Object)envId, (Object)envName);
                    continue;
                }
                if (!envLabelValue.equals(envName)) continue;
                tpcAppInfo.setEnvId(envId);
                tpcAppInfo.setEnvName(envName);
                break;
            }
        }
        catch (Exception e) {
            log.error("get env parse tpc resp error, ", (Throwable)e);
        }
    }

    private String getAppValueByAppKeyType(JSONObject admissionRequest) {
        String appLabelValue = null;
        if ("label".equals(this.appKeyType)) {
            appLabelValue = this.getLabelValue(this.appKeyName, admissionRequest.getJSONObject("object").getJSONObject("metadata").getJSONObject("labels"));
        } else if ("env".equals(this.appKeyType)) {
            appLabelValue = System.getenv(this.appKeyName);
        }
        return appLabelValue;
    }

    private String getEnvValueByEnvKeyType(JSONObject admissionRequest) {
        String envLabelValue = null;
        if ("label".equals(this.envKeyType)) {
            envLabelValue = this.getLabelValue(this.envKeyName, admissionRequest.getJSONObject("object").getJSONObject("metadata").getJSONObject("labels"));
        } else if ("env".equals(this.envKeyType)) {
            envLabelValue = System.getenv(this.envKeyName);
        }
        return envLabelValue;
    }

    private void setOzHeraEnvs(List<JsonPatch> result, String path, TpcAppInfo appInfo, Set<String> envKeys) {
        log.info("begin setOzHeraEnvs appInfo: {}, envKeys: {}", (Object)appInfo, envKeys);
        if (!envKeys.contains(APPLICATION) && StringUtils.isNotEmpty((CharSequence)appInfo.getIdAndName())) {
            result.add(new JsonPatch<EnvVar>("add", path, this.buildEnv(APPLICATION, appInfo.getIdAndName().replaceAll("-", "_"))));
        }
        if (!envKeys.contains(SERVER_ENV) && StringUtils.isNotEmpty((CharSequence)appInfo.getEnvName())) {
            result.add(new JsonPatch<EnvVar>("add", path, this.buildEnv(SERVER_ENV, appInfo.getEnvName())));
        }
        if (!envKeys.contains(MIONE_PROJECT_NAME) && StringUtils.isNotEmpty((CharSequence)appInfo.getIdAndName())) {
            result.add(new JsonPatch<EnvVar>("add", path, this.buildEnv(MIONE_PROJECT_NAME, appInfo.getIdAndName())));
        }
        if (!envKeys.contains(MIONE_PROJECT_ENV_ID) && appInfo.getEnvId() != null && appInfo.getEnvId() != 0L) {
            result.add(new JsonPatch<EnvVar>("add", path, this.buildEnv(MIONE_PROJECT_ENV_ID, String.valueOf(appInfo.getEnvId()))));
        }
        if (!envKeys.contains(MIONE_PROJECT_ENV_NAME) && StringUtils.isNotEmpty((CharSequence)appInfo.getEnvName())) {
            result.add(new JsonPatch<EnvVar>("add", path, this.buildEnv(MIONE_PROJECT_ENV_NAME, appInfo.getEnvName())));
        }
        log.info("end setOzHeraEnvs appInfo: {}, envKeys: {}", (Object)appInfo, envKeys);
    }

    private boolean includeNameSpace(String namespace) {
        if (StringUtils.isEmpty((CharSequence)namespace) || this.logAgentConditionNameSpaceLists.isEmpty()) {
            return false;
        }
        return this.logAgentConditionNameSpaceLists.contains(namespace);
    }

    private boolean filterByPodName(JSONObject admissionRequest) {
        if (this.podPrefixesLists.isEmpty()) {
            return false;
        }
        String name = this.getPodName(admissionRequest);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            for (String prefix : this.podPrefixesLists) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    private String getPodName(JSONObject admissionRequest) {
        String name = admissionRequest.getString("name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            JSONObject metadata = admissionRequest.getJSONObject("object").getJSONObject("metadata");
            name = metadata.getString("generateName");
        }
        log.info("get pod name is : " + name);
        return name;
    }

    private boolean includeVolumeMounts(JSONObject container) {
        if (this.logAgentVolumeMountNameList.isEmpty()) {
            return false;
        }
        JSONArray volumeMountsJson = container.getJSONArray("volumeMounts");
        if (volumeMountsJson != null) {
            for (int j = 0; j < volumeMountsJson.size(); ++j) {
                JSONObject volumeMountJson = volumeMountsJson.getJSONObject(j);
                if (!this.logAgentVolumeMountNameList.contains(volumeMountJson.getString("name"))) continue;
                return true;
            }
        }
        return false;
    }

    private VolumeMount getVolumeMountAndAddEnv(JSONObject container, List<EnvVar> envs, String podName) {
        JSONArray volumeMountsJson = container.getJSONArray("volumeMounts");
        log.info("getVolumeMountAndAddEnv.volumeMountsJson is : " + String.valueOf(volumeMountsJson));
        if (volumeMountsJson != null) {
            JSONArray env = container.getJSONArray("env");
            List<EnvVar> envsForLogAgent = this.copyEnvForLogAgent(env);
            for (int i = 0; i < volumeMountsJson.size(); ++i) {
                JSONObject volumeMountJson = volumeMountsJson.getJSONObject(i);
                String volumeMountName = volumeMountJson.getString("name");
                log.info("getVolumeMountAndAddEnv.volumeMountName is : " + volumeMountName);
                if (!this.logAgentVolumeMountNameList.contains(volumeMountName)) continue;
                envs.addAll(envsForLogAgent);
                return this.copyVolumeForLogAgent(volumeMountJson, envs, podName);
            }
        }
        return null;
    }

    private List<EnvVar> copyEnvForLogAgent(JSONArray envsJson) {
        ArrayList<EnvVar> envs = new ArrayList<EnvVar>();
        envs.add(this.buildEnvRef("POD_NAME", "v1", "metadata.name"));
        return envs;
    }

    private VolumeMount copyVolumeForLogAgent(JSONObject volumeMountJson, List<EnvVar> envs, String podName) {
        VolumeMount volumeMount = new VolumeMount();
        volumeMount.setName(volumeMountJson.getString("name"));
        volumeMount.setMountPath(volumeMountJson.getString("mountPath"));
        volumeMount.setSubPathExpr(podName);
        return volumeMount;
    }

    private void buildLogAgentContainer(VolumeMount volumeMount, List<EnvVar> envs, List<JsonPatch> jsonPatches) {
        if (jsonPatches == null) {
            jsonPatches = new ArrayList<JsonPatch>();
        }
        String path = "/spec/containers/-";
        Container container = new Container();
        container.setName(this.logAgentContainerName);
        container.setImage(this.logAgentContainerImage);
        Limits limits = new Limits();
        limits.setCpu(this.logAgentContainerCpuLimit);
        limits.setMemory(this.logAgentContainerMemLimit);
        Requests requests = new Requests();
        requests.setCpu(this.logAgentContainerCpuLimit);
        requests.setMemory(this.logAgentContainerMemLimit);
        Resource resource = new Resource();
        resource.setLimits(limits);
        resource.setRequests(requests);
        container.setResources(resource);
        container.setVolumeMounts(Collections.singletonList(volumeMount));
        envs.add(this.buildEnv(LOG_AGENT_NACOS_ENV_KEY, this.logAgentNacosAddr));
        container.setEnv(envs);
        log.info("log agent Container is : " + String.valueOf(container));
        jsonPatches.add(new JsonPatch<Container>("add", path, container));
        log.info("log agent added");
    }
}

