/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.properties.config;

import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.beans.factory.annotation.ConfigServiceBeanBuilder;
import com.alibaba.nacos.spring.context.event.config.EventPublishingConfigService;
import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import com.alibaba.nacos.spring.context.event.config.NacosConfigurationPropertiesBeanBoundEvent;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.nacos.spring.util.ObjectUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class NacosConfigurationPropertiesBinder {
    public static final String BEAN_NAME = "nacosConfigurationPropertiesBinder";
    private static final Logger logger = LoggerFactory.getLogger(NacosConfigurationPropertiesBinder.class);
    private final ConfigurableApplicationContext applicationContext;
    private final Environment environment;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ConfigServiceBeanBuilder configServiceBeanBuilder;

    protected NacosConfigurationPropertiesBinder(ConfigurableApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ConfigurableApplicationContext must not be null!");
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
        this.applicationEventPublisher = applicationContext;
        this.configServiceBeanBuilder = NacosBeanUtils.getConfigServiceBeanBuilder((BeanFactory)applicationContext);
    }

    protected void bind(Object bean, String beanName) {
        NacosConfigurationProperties properties = (NacosConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), NacosConfigurationProperties.class);
        this.bind(bean, beanName, properties);
    }

    protected void bind(final Object bean, final String beanName, final NacosConfigurationProperties properties) {
        String content;
        ConfigService configService;
        String type;
        String groupId;
        String dataId;
        block6: {
            Assert.notNull((Object)bean, (String)"Bean must not be null!");
            Assert.notNull((Object)properties, (String)"NacosConfigurationProperties must not be null!");
            dataId = NacosUtils.readFromEnvironment(properties.dataId(), this.environment);
            groupId = NacosUtils.readFromEnvironment(properties.groupId(), this.environment);
            String fileType = NacosUtils.readTypeFromDataId(dataId);
            type = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileType) ? (properties.yaml() ? ConfigType.YAML.getType() : properties.type().getType()) : fileType;
            configService = (ConfigService)this.configServiceBeanBuilder.build(properties.properties());
            if (properties.autoRefreshed()) {
                AbstractListener listener = new AbstractListener(){

                    public void receiveConfigInfo(String config) {
                        NacosConfigurationPropertiesBinder.this.doBind(bean, beanName, dataId, groupId, type, properties, config, configService);
                    }
                };
                try {
                    if (configService instanceof EventPublishingConfigService) {
                        ((EventPublishingConfigService)configService).addListener(dataId, groupId, type, (Listener)listener);
                    } else {
                        configService.addListener(dataId, groupId, (Listener)listener);
                    }
                }
                catch (NacosException e) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (StringUtils.hasText((String)(content = NacosUtils.getContent(configService, dataId, groupId)))) {
            this.doBind(bean, beanName, dataId, groupId, type, properties, content, configService);
        }
    }

    protected void doBind(Object bean, String beanName, String dataId, String groupId, String type, NacosConfigurationProperties properties, String content, ConfigService configService) {
        String prefix = properties.prefix();
        PropertyValues propertyValues = NacosUtils.resolvePropertyValues(bean, prefix, dataId, groupId, content, type);
        this.doBind(bean, properties, propertyValues);
        this.publishBoundEvent(bean, beanName, dataId, groupId, properties, content, configService);
        this.publishMetadataEvent(bean, beanName, dataId, groupId, properties);
    }

    protected void publishMetadataEvent(Object bean, String beanName, String dataId, String groupId, NacosConfigurationProperties properties) {
        NacosProperties nacosProperties = properties.properties();
        NacosConfigMetadataEvent metadataEvent = new NacosConfigMetadataEvent(properties);
        metadataEvent.setDataId(dataId);
        metadataEvent.setGroupId(groupId);
        Properties resolvedNacosProperties = this.configServiceBeanBuilder.resolveProperties(nacosProperties);
        Map nacosPropertiesAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties);
        metadataEvent.setNacosPropertiesAttributes(nacosPropertiesAttributes);
        metadataEvent.setNacosProperties(resolvedNacosProperties);
        Class<?> beanClass = bean.getClass();
        metadataEvent.setBeanName(beanName);
        metadataEvent.setBean(bean);
        metadataEvent.setBeanType(beanClass);
        metadataEvent.setAnnotatedElement(beanClass);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)metadataEvent);
    }

    protected void publishBoundEvent(Object bean, String beanName, String dataId, String groupId, NacosConfigurationProperties properties, String content, ConfigService configService) {
        NacosConfigurationPropertiesBeanBoundEvent event = new NacosConfigurationPropertiesBeanBoundEvent(configService, dataId, groupId, bean, beanName, properties, content);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }

    private void doBind(Object bean, NacosConfigurationProperties properties, PropertyValues propertyValues) {
        ObjectUtils.cleanMapOrCollectionField(bean);
        DataBinder dataBinder = new DataBinder(bean);
        dataBinder.setAutoGrowNestedPaths(properties.ignoreNestedProperties());
        dataBinder.setIgnoreInvalidFields(properties.ignoreInvalidFields());
        dataBinder.setIgnoreUnknownFields(properties.ignoreUnknownFields());
        dataBinder.bind(propertyValues);
    }
}

