/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.rocketmq;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.stream.common.SinkJobEnum;
import org.apache.ozhera.log.stream.job.extension.MQPlugin;
import org.apache.ozhera.log.stream.job.extension.rocketmq.RocketmqConfig;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class RocketmqPlugin
implements MQPlugin {
    private static final Logger log = LoggerFactory.getLogger(RocketmqPlugin.class);

    public static RocketmqConfig buildRocketmqConfig(String ak, String sk, String clusterInfo, String topic, String tag, SinkJobEnum jobType) {
        RocketmqConfig config = new RocketmqConfig();
        Config ins = Config.ins();
        config.setNamesrvAddr(StringUtils.isNotEmpty((CharSequence)clusterInfo) ? clusterInfo : ins.get("rocketmq_namesrv_addr", ""));
        config.setAk(StringUtils.isNotEmpty((CharSequence)ak) ? ak : ins.get("rocketmq_ak", ""));
        config.setSk(StringUtils.isNotEmpty((CharSequence)sk) ? sk : ins.get("rocketmq_sk", ""));
        config.setConsumerFromWhere(ins.get("rocketmq_consumer_offset", ""));
        config.setConsumerGroup("subGroup_" + tag);
        if (SinkJobEnum.BACKUP_JOB == jobType) {
            config.setConsumerGroup("subGroup_" + tag + "_backup");
        }
        config.setTopicName(topic);
        config.setTag(tag);
        log.info("[RmqSinkJob.initJob] print consumer config:{}", (Object)config);
        return config;
    }

    public static DefaultMQPushConsumer getRocketMqConsumer(RocketmqConfig rocketmqConfig) {
        return RocketmqPlugin.initDefaultMQPushConsumer(rocketmqConfig);
    }

    public static DefaultMQPushConsumer initDefaultMQPushConsumer(RocketmqConfig config) {
        DefaultMQPushConsumer defaultMQPushConsumer;
        if (StringUtils.isNotEmpty((CharSequence)config.getAk()) && StringUtils.isNotEmpty((CharSequence)config.getSk())) {
            SessionCredentials credentials = new SessionCredentials(config.getAk(), config.getSk());
            AclClientRPCHook rpcHook = new AclClientRPCHook(credentials);
            defaultMQPushConsumer = new DefaultMQPushConsumer("milog_topic_group_staging_event_staging", (RPCHook)rpcHook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
        } else {
            defaultMQPushConsumer = new DefaultMQPushConsumer(config.getConsumerGroup());
        }
        defaultMQPushConsumer.setNamesrvAddr(config.getNamesrvAddr());
        defaultMQPushConsumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        return defaultMQPushConsumer;
    }

    private static ConsumeFromWhere getConsumeFromWhere(String offset) {
        if (Optional.ofNullable(offset).isPresent()) {
            switch (offset) {
                case "last_offset": {
                    return ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
                }
                case "first_offset": {
                    return ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET;
                }
                case "timestamp": {
                    return ConsumeFromWhere.CONSUME_FROM_TIMESTAMP;
                }
            }
            return ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
        }
        return ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
    }
}

