/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.model.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.ozhera.log.api.enums.RateLimitEnum;
import org.apache.ozhera.log.api.filter.RateLimitStrategy;

public class FilterDefine
implements Serializable {
    private String code;
    private Map<String, String> args;

    public static FilterDefine Of(String code, Map<String, String> args) {
        return new FilterDefine(code, args);
    }

    public static FilterDefine consFilterDefine(final RateLimitStrategy strategy) {
        return FilterDefine.Of(strategy.getCode(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("permitsPerSecond", String.valueOf(strategy.getPermitsPerSecond()));
            }
        });
    }

    public static FilterDefine consRateLimitFilterDefine(String rateLimit) {
        if (rateLimit == null) {
            return null;
        }
        RateLimitEnum rateLimitEnum = RateLimitEnum.queryByRateLimit(rateLimit);
        switch (rateLimitEnum) {
            case RATE_LIMIT_FAST: {
                return FilterDefine.consFilterDefine(RateLimitStrategy.REGINAL_FAST);
            }
            case RATE_LIMIT_MEDIUM: {
                return FilterDefine.consFilterDefine(RateLimitStrategy.REGINAL_MEDIUM);
            }
            case RATE_LIMIT_SLOW: {
                return FilterDefine.consFilterDefine(RateLimitStrategy.REGINAL_SLOW);
            }
            case RATE_LIMIT_NONE: {
                return FilterDefine.consFilterDefine(RateLimitStrategy.REGINAL_NONE);
            }
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setArgs(Map<String, String> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterDefine)) {
            return false;
        }
        FilterDefine other = (FilterDefine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Map<String, String> this$args = this.getArgs();
        Map<String, String> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterDefine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Map<String, String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public String toString() {
        return "FilterDefine(code=" + this.getCode() + ", args=" + String.valueOf(this.getArgs()) + ")";
    }

    public FilterDefine() {
    }

    public FilterDefine(String code, Map<String, String> args) {
        this.code = code;
        this.args = args;
    }
}

