/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum ProjectSourceEnum {
    ONE_SOURCE(0, "test1", "test1"),
    TWO_SOURCE(1, "test2", "test2"),
    NO_KNOW_SOURCE(-1, "un_know", "Unknown");

    private final Integer code;
    private final String source;
    private final String describe;
    private static Map<Integer, ProjectSourceEnum> codeLookup;
    private static Map<String, ProjectSourceEnum> sourceLookup;

    private ProjectSourceEnum(Integer code, String source, String describe) {
        this.code = code;
        this.source = source;
        this.describe = describe;
    }

    public static ProjectSourceEnum queryForCode(int code) {
        ProjectSourceEnum anEnum = codeLookup.get(code);
        return anEnum == null ? NO_KNOW_SOURCE : anEnum;
    }

    public static ProjectSourceEnum queryForSource(String source) {
        ProjectSourceEnum anEnum = sourceLookup.get(source);
        return anEnum == null ? NO_KNOW_SOURCE : anEnum;
    }

    public static int queryCodeBySource(String source) {
        return Arrays.stream(ProjectSourceEnum.values()).filter(machineTypeEnum -> Objects.equals(machineTypeEnum.source, source)).findFirst().map(ProjectSourceEnum::getCode).orElse(null);
    }

    public static String querySourceByDesc(String desc) {
        return Arrays.stream(ProjectSourceEnum.values()).filter(machineTypeEnum -> Objects.equals(machineTypeEnum.describe, desc)).findFirst().map(ProjectSourceEnum::getSource).orElse(ONE_SOURCE.getSource());
    }

    public Integer getCode() {
        return this.code;
    }

    public String getSource() {
        return this.source;
    }

    public String getDescribe() {
        return this.describe;
    }

    static {
        codeLookup = new HashMap<Integer, ProjectSourceEnum>();
        sourceLookup = new HashMap<String, ProjectSourceEnum>();
        Arrays.stream(ProjectSourceEnum.values()).forEach(projectSourceEnum -> {
            codeLookup.put(projectSourceEnum.code, (ProjectSourceEnum)((Object)projectSourceEnum));
            sourceLookup.put(projectSourceEnum.source, (ProjectSourceEnum)((Object)projectSourceEnum));
        });
    }
}

