/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.es;

import com.xiaomi.mone.es.EsClient;
import com.xiaomi.mone.es.ProcessorConf;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsProcessor {
    private static final Logger log = LoggerFactory.getLogger(EsProcessor.class);
    private RestHighLevelClient originalClient;
    private BulkProcessor bulkProcessor;
    private EsClient client;

    public EsProcessor(ProcessorConf conf) {
        this.client = conf.getEsClient();
        BulkProcessor.Builder builder = BulkProcessor.builder((request, bulkListener) -> this.originalClient.bulkAsync(request, RequestOptions.DEFAULT, bulkListener), (BulkProcessor.Listener)conf.getListener());
        builder.setBulkActions(conf.getBulkActions());
        builder.setBulkSize(new ByteSizeValue(conf.getByteSize(), ByteSizeUnit.MB));
        builder.setConcurrentRequests(conf.getConcurrentRequest());
        builder.setFlushInterval(TimeValue.timeValueMillis((long)conf.getFlushInterval()));
        builder.setBackoffPolicy(BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueSeconds((long)conf.getRetryInterval()), (int)conf.getRetryNumber())).build();
        this.bulkProcessor = builder.build();
        this.originalClient = conf.getEsClient().getEsOriginalClient();
    }

    public void close() {
        this.bulkProcessor.close();
    }

    public boolean awaitClose(int timeout) throws InterruptedException {
        return this.bulkProcessor.awaitClose((long)timeout, TimeUnit.SECONDS);
    }

    public void flush() {
        this.bulkProcessor.flush();
    }

    public void bulkInsert(String indexName, Map<String, Object> data) {
        this.bulkProcessor.add((IndexRequest)new IndexRequest(indexName).source(data).timeout(new TimeValue(1L, TimeUnit.MINUTES)));
    }

    public void bulkInsert(IndexRequest indexRequest) {
        this.bulkProcessor.add(indexRequest);
    }

    public void bulkUpdate(String indexName, String dataId, Map<String, Object> data) {
        this.bulkProcessor.add((DocWriteRequest)new UpdateRequest(indexName, dataId).doc(data).timeout(new TimeValue(1L, TimeUnit.MINUTES)));
    }

    public void bulkUpdate(UpdateRequest updateRequest) {
        this.bulkProcessor.add((DocWriteRequest)updateRequest);
    }

    public void bulkUpsert(String indexName, String dataId, Map<String, Object> data) {
        this.bulkProcessor.add((DocWriteRequest)new UpdateRequest(indexName, dataId).doc(data).docAsUpsert(true).retryOnConflict(2).timeout(new TimeValue(1L, TimeUnit.MINUTES)));
    }
}

