/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.upload.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nutz.mvc.upload.util.MarkUnloadedRingItemException;
import org.nutz.mvc.upload.util.ReloadLoadedRingItemException;

class RingItem {
    byte[] buffer;
    int max;
    int l;
    int r;
    int nextmark;
    RingItem next;
    boolean isLoaded;
    boolean isStreamEnd;

    RingItem(int width) {
        this.buffer = new byte[width];
        this.next = this;
    }

    RingItem createNext() {
        RingItem ri = new RingItem(this.buffer.length);
        ri.next = this.next;
        this.next = ri;
        return ri;
    }

    void load(InputStream ins) throws IOException {
        if (this.isLoaded) {
            throw new ReloadLoadedRingItemException();
        }
        int bufferSize = this.buffer.length;
        this.max = ins.read(this.buffer, 0, bufferSize);
        if (this.max < 0) {
            this.max = 0;
            this.isStreamEnd = true;
        } else {
            while (this.max < bufferSize) {
                int re = ins.read(this.buffer, this.max, bufferSize - this.max);
                if (re == -1) {
                    this.isStreamEnd = true;
                    break;
                }
                this.max += re;
            }
        }
        this.l = 0;
        this.r = 0;
        this.nextmark = 0;
        this.isLoaded = true;
    }

    void dump(OutputStream ops) throws IOException {
        if (this.l < this.r) {
            ops.write(this.buffer, this.l, this.r - this.l);
        }
        this.r = this.l = this.nextmark;
        this.isLoaded = this.l < this.max;
    }

    boolean matchHeadingWithRemain(byte[] bs, int offs) {
        int i = 0;
        while (offs < bs.length) {
            if (this.buffer[i++] != bs[offs]) {
                this.r = i;
                return false;
            }
            ++offs;
        }
        this.l = i;
        this.r = i;
        this.nextmark = i;
        return true;
    }

    boolean isDone4Mark() {
        return this.nextmark == this.max;
    }

    int mark(byte[] bs, int[] fails) {
        if (!this.isLoaded) {
            throw new MarkUnloadedRingItemException();
        }
        byte start = bs[0];
        while (this.r < this.max) {
            if (this.buffer[this.r] == start) {
                int re = 0;
                int j = this.r;
                while (true) {
                    ++j;
                    if (++re == bs.length) {
                        this.nextmark = j;
                        return -1;
                    }
                    if (j == this.max) {
                        this.nextmark = this.max;
                        if (this.isStreamEnd) {
                            this.r = this.max;
                            return 0;
                        }
                        return re;
                    }
                    if (bs[re] == this.buffer[j]) continue;
                    if (bs[re = fails[re]] != this.buffer[j]) break;
                    if (re == 0) {
                        this.r = j;
                        continue;
                    }
                    this.r += re == 0 ? 1 : re;
                }
                this.r = j;
            }
            ++this.r;
        }
        this.nextmark = this.max;
        return 0;
    }
}

