/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.handler;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.JsonTypeHandler;
import org.nutz.json.entity.JsonCallback;
import org.nutz.json.entity.JsonEntity;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.json.impl.JsonPair;
import org.nutz.lang.FailToGetValueException;
import org.nutz.lang.Mirror;

public class JsonPojoHandler
extends JsonTypeHandler {
    @Override
    public boolean supportFromJson(Mirror<?> mirror, Object obj) {
        return false;
    }

    @Override
    public boolean supportToJson(Mirror<?> mirror, Object obj, JsonFormat jf) {
        return true;
    }

    @Override
    public void toJson(Mirror<?> _mirror, Object obj, JsonRender r, JsonFormat format) throws IOException {
        if (null == obj) {
            return;
        }
        Class<?> type = obj.getClass();
        if (type == JsonPojoHandler.class) {
            return;
        }
        JsonEntity jen = Json.getEntity(Mirror.me(type));
        JsonCallback jsonCallback = jen.getJsonCallback();
        if (jsonCallback != null && jsonCallback.toJson(obj, format, r.getWriter())) {
            return;
        }
        List<JsonEntityField> fields = jen.getFields();
        r.appendBraceBegin();
        r.increaseFormatIndent();
        ArrayList<JsonPair> list = new ArrayList<JsonPair>(fields.size());
        for (JsonEntityField jef : fields) {
            if (jef.isIgnore()) continue;
            String name = jef.getName();
            try {
                Object value = jef.getValue(obj);
                if (r.isIgnore(name, value)) continue;
                Mirror<?> mirror = jef.getMirror();
                if (null != value && mirror.isPojo() && r.memoContains(value)) {
                    value = null;
                }
                if (null == value) {
                    if (mirror != null) {
                        if (mirror.isStringLike()) {
                            if (format.isNullStringAsEmpty()) {
                                value = "";
                            }
                        } else if (mirror.isNumber()) {
                            if (format.isNullNumberAsZero()) {
                                value = 0;
                            }
                        } else if (mirror.isCollection()) {
                            if (format.isNullListAsEmpty()) {
                                value = Collections.EMPTY_LIST;
                            }
                        } else if (jef.getGenericType() == Boolean.class && format.isNullBooleanAsFalse()) {
                            value = false;
                        }
                    }
                } else if (jef.isForceString()) {
                    if (value.getClass().isArray()) {
                        String[] ss = new String[Array.getLength(value)];
                        for (int i = 0; i < ss.length; ++i) {
                            ss[i] = Array.get(value, i).toString();
                        }
                        value = ss;
                    } else if (value instanceof Collection) {
                        Collection col = (Collection)Mirror.me(value).born(new Object[0]);
                        for (Object ele : (Collection)value) {
                            col.add(ele.toString());
                        }
                        value = col;
                    } else {
                        value = r.value2string(jef, value);
                    }
                } else if (jef.hasDataFormat() && value instanceof Date) {
                    value = jef.getDataFormat().format(value);
                } else if (jef.hasDataFormat() && mirror != null && mirror.isNumber()) {
                    value = jef.getDataFormat().format(value);
                }
                list.add(new JsonPair(name, value));
            }
            catch (FailToGetValueException failToGetValueException) {}
        }
        r.writeItem(list);
    }

    @Override
    public Object fromJson(Object obj, Mirror<?> mirror) throws Exception {
        return null;
    }

    @Override
    public boolean shallCheckMemo() {
        return true;
    }
}

