/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.http.Http;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.util.NutMap;

public class Header {
    protected NutMap items = new NutMap();

    protected Header() {
    }

    public Collection<String> keys() {
        return this.items.keySet();
    }

    public String get(String key) {
        Object value = this.items.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            if (((List)value).isEmpty()) {
                return null;
            }
            return (String)((List)value).get(0);
        }
        return (String)value;
    }

    public Header set(String key, String value) {
        if (null != key) {
            this.items.put(key, value);
        }
        return this;
    }

    public Header remove(String key) {
        this.items.remove(key);
        return this;
    }

    public Header clear() {
        this.items.clear();
        return this;
    }

    public Set<Map.Entry<String, String>> getAll() {
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (String key : this.items.keySet()) {
            String value = this.get(key);
            if (value == null) continue;
            tmp.put(key, value);
        }
        return tmp.entrySet();
    }

    public Header addAll(Map<String, String> map) {
        if (null != map) {
            this.items.putAll(map);
        }
        return this;
    }

    public String toString() {
        return Json.toJson(this.items, JsonFormat.nice().setIgnoreNull(false));
    }

    public static Header create(Map<String, String> properties) {
        return new Header().addAll(properties);
    }

    public static Header create(NutMap reHeader) {
        Header header = new Header();
        header.items.putAll(reHeader);
        return header;
    }

    public static Header create(String properties) {
        return Header.create((Map)Json.fromJson(properties));
    }

    public static Header create() {
        Header header = new Header();
        header.addAll(Http.DEFAULT_HEADERS);
        return header;
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public Header asJsonContentType() {
        return this.asJsonContentType(null);
    }

    public Header asFormContentType() {
        return this.asFormContentType(null);
    }

    public Header asJsonContentType(String enc) {
        if (enc == null) {
            enc = Charset.defaultCharset().name();
        }
        this.set("Content-Type", "application/json; charset=" + enc.toUpperCase());
        return this;
    }

    public Header asFormContentType(String enc) {
        if (enc == null) {
            enc = Charset.defaultCharset().name();
        }
        this.set("Content-Type", "application/x-www-form-urlencoded; charset=" + enc.toUpperCase());
        return this;
    }

    public void addv(String name, String value) {
        if (value == null) {
            this.items.remove(name);
        } else {
            this.items.addv(name, value);
        }
    }

    public List<String> getValues(String name) {
        Object value = this.items.get(name);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof String) {
            return Arrays.asList((String)value);
        }
        return (List)value;
    }
}

