/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;

public class SimpleBlob
implements Blob,
Serializable {
    private static final long serialVersionUID = 4192412466410263969L;
    protected File file;

    public SimpleBlob() {
    }

    public SimpleBlob(File f) {
        this.file = f;
    }

    @Override
    public long length() throws SQLException {
        return this.file.length();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos == 1L && (long)length == this.length()) {
            return Streams.readBytesAndClose(this.getBinaryStream());
        }
        throw Lang.noImplement();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return Streams.buff(Streams.fileIn(this.file));
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public void truncate(long len) throws SQLException {
        Files.write(this.file, (Object)new Byte[0]);
    }

    @Override
    public void free() throws SQLException {
        Files.deleteFile(this.file);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw Lang.noImplement();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Streams.writeAndClose((OutputStream)out, new FileInputStream(this.file));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.file = Jdbcs.getFilePool().createFile(".blob");
        Files.write(this.file, (Object)in);
    }

    public void setFile(File file) {
        this.file = file;
    }
}

