/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.Record;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.entity.EntityObjectContext;
import org.nutz.dao.impl.entity.field.AbstractEntityField;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.lang.segment.Segment;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NutMappingField
extends AbstractEntityField
implements MappingField {
    private String columnName;
    private String columnNameInSql;
    private ColType columnType;
    private Segment defaultValue;
    private String columnComment;
    private int width;
    private int precision;
    private boolean isCompositePk;
    private boolean isId;
    private boolean isName;
    private boolean isVersion;
    private boolean readonly;
    private boolean notNull;
    private boolean unsigned;
    private boolean autoIncreasement;
    private boolean casesensitive = true;
    private boolean hasColumnComment;
    private String customDbType;
    private ValueAdaptor adaptor;
    private boolean insert = true;
    private boolean update = true;
    private static final Log log = Logs.get();

    public NutMappingField(Entity<?> entity) {
        super(entity);
    }

    @Override
    public ValueAdaptor getAdaptor() {
        return this.adaptor;
    }

    @Override
    public void setAdaptor(ValueAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    @Override
    public void injectValue(Object obj, Record rec, String prefix) {
        block2: {
            try {
                Object val = rec.get(prefix == null ? this.columnName : prefix + this.columnName);
                this.setValue(obj, val);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.tracef("columnName=" + this.columnName, e);
            }
        }
    }

    @Override
    public void injectValue(Object obj, ResultSet rs, String prefix) {
        block2: {
            try {
                this.setValue(obj, this.adaptor.get(rs, prefix == null ? this.columnName : prefix + this.columnName));
            }
            catch (SQLException e) {
                if (!log.isTraceEnabled()) break block2;
                log.tracef("columnName=" + this.columnName, e);
            }
        }
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public ColType getColumnType() {
        return this.columnType;
    }

    @Override
    public String getDefaultValue(Object obj) {
        if (null == this.defaultValue) {
            return null;
        }
        String re = null == obj || this.defaultValue.keyCount() == 0 ? this.defaultValue.toString() : this.defaultValue.render(new EntityObjectContext(this.getEntity(), obj)).toString();
        return re;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public boolean isCompositePk() {
        return this.isCompositePk;
    }

    @Override
    public boolean isPk() {
        return this.isId || !this.isId && this.isName || this.isCompositePk;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean isName() {
        return this.isName;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public boolean hasDefaultValue() {
        return null != this.defaultValue;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public boolean isCasesensitive() {
        return this.casesensitive;
    }

    @Override
    public boolean isAutoIncreasement() {
        return this.autoIncreasement;
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setColumnType(ColType columnType) {
        this.columnType = columnType;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    public void setHasColumnComment(boolean hasColumnComment) {
        this.hasColumnComment = hasColumnComment;
    }

    public void setDefaultValue(Segment defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setAsCompositePk() {
        this.isCompositePk = true;
    }

    public void setAsId() {
        this.isId = true;
    }

    public void setAsName() {
        this.isName = true;
    }

    @Override
    public void setAsReadonly() {
        this.readonly = true;
    }

    @Override
    public void setAsNotNull() {
        this.notNull = true;
    }

    public void setAsUnsigned() {
        this.unsigned = true;
    }

    public void setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
    }

    public void setAsAutoIncreasement() {
        this.autoIncreasement = true;
    }

    public void setAutoIncreasement(boolean autoIncreasement) {
        this.autoIncreasement = autoIncreasement;
    }

    @Override
    public String getColumnComment() {
        return this.columnComment;
    }

    @Override
    public boolean hasColumnComment() {
        return this.hasColumnComment;
    }

    @Override
    public void setCustomDbType(String customDbType) {
        this.customDbType = customDbType;
    }

    @Override
    public String getCustomDbType() {
        return this.customDbType;
    }

    @Override
    public boolean isInsert() {
        return this.insert;
    }

    @Override
    public boolean isUpdate() {
        return this.update;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Override
    public String getColumnNameInSql() {
        if (this.columnNameInSql != null) {
            return this.columnNameInSql;
        }
        return this.columnName;
    }

    public void setColumnNameInSql(String columnNameInSql) {
        this.columnNameInSql = columnNameInSql;
    }

    @Override
    public boolean isVersion() {
        return this.isVersion;
    }

    public void setAsVersion() {
        this.isVersion = true;
    }
}

