/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.interceptor;

import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.trans.Trans;

public class TransactionInterceptor
implements MethodInterceptor {
    private int level;

    public TransactionInterceptor() {
        this.level = 2;
    }

    public TransactionInterceptor(int level) {
        this.level = level;
    }

    @Override
    public void filter(InterceptorChain chain) throws Throwable {
        try {
            Trans.begin(this.level);
            chain.doChain();
            Trans.commit();
        }
        catch (Throwable e) {
            Trans.rollback();
            throw e;
        }
        finally {
            Trans.close();
        }
    }
}

