/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;

public class InnerEnum
extends JavaElement {
    private List<Field> fields;
    private List<InnerClass> innerClasses;
    private List<InnerEnum> innerEnums;
    private FullyQualifiedJavaType type;
    private Set<FullyQualifiedJavaType> superInterfaceTypes;
    private List<Method> methods;
    private List<String> enumConstants;

    public InnerEnum(FullyQualifiedJavaType type) {
        this.type = type;
        this.fields = new ArrayList<Field>();
        this.innerClasses = new ArrayList<InnerClass>();
        this.innerEnums = new ArrayList<InnerEnum>();
        this.superInterfaceTypes = new HashSet<FullyQualifiedJavaType>();
        this.methods = new ArrayList<Method>();
        this.enumConstants = new ArrayList<String>();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public List<InnerClass> getInnerClasses() {
        return this.innerClasses;
    }

    public void addInnerClass(InnerClass innerClass) {
        this.innerClasses.add(innerClass);
    }

    public List<InnerEnum> getInnerEnums() {
        return this.innerEnums;
    }

    public void addInnerEnum(InnerEnum innerEnum) {
        this.innerEnums.add(innerEnum);
    }

    public List<String> getEnumConstants() {
        return this.enumConstants;
    }

    public void addEnumConstant(String enumConstant) {
        this.enumConstants.add(enumConstant);
    }

    public String getFormattedContent(int indentLevel, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        this.addFormattedJavadoc(sb, indentLevel);
        this.addFormattedAnnotations(sb, indentLevel);
        OutputUtilities.javaIndent(sb, indentLevel);
        if (this.getVisibility() == JavaVisibility.PUBLIC) {
            sb.append(this.getVisibility().getValue());
        }
        sb.append("enum ");
        sb.append(this.getType().getShortName());
        if (this.superInterfaceTypes.size() > 0) {
            sb.append(" implements ");
            boolean comma = false;
            for (FullyQualifiedJavaType fqjt : this.superInterfaceTypes) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(JavaDomUtils.calculateTypeName(compilationUnit, fqjt));
            }
        }
        sb.append(" {");
        ++indentLevel;
        Iterator<String> strIter = this.enumConstants.iterator();
        while (strIter.hasNext()) {
            OutputUtilities.newLine(sb);
            OutputUtilities.javaIndent(sb, indentLevel);
            String enumConstant = strIter.next();
            sb.append(enumConstant);
            if (strIter.hasNext()) {
                sb.append(',');
                continue;
            }
            sb.append(';');
        }
        if (this.fields.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<Field> fldIter = this.fields.iterator();
        while (fldIter.hasNext()) {
            OutputUtilities.newLine(sb);
            Field field = fldIter.next();
            sb.append(field.getFormattedContent(indentLevel, compilationUnit));
            if (!fldIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        if (this.methods.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<Method> mtdIter = this.methods.iterator();
        while (mtdIter.hasNext()) {
            OutputUtilities.newLine(sb);
            Method method = mtdIter.next();
            sb.append(method.getFormattedContent(indentLevel, false, compilationUnit));
            if (!mtdIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        if (this.innerClasses.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<InnerClass> icIter = this.innerClasses.iterator();
        while (icIter.hasNext()) {
            OutputUtilities.newLine(sb);
            InnerClass innerClass = icIter.next();
            sb.append(innerClass.getFormattedContent(indentLevel, compilationUnit));
            if (!icIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        if (this.innerEnums.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<InnerEnum> ieIter = this.innerEnums.iterator();
        while (ieIter.hasNext()) {
            OutputUtilities.newLine(sb);
            InnerEnum innerEnum = ieIter.next();
            sb.append(innerEnum.getFormattedContent(indentLevel, compilationUnit));
            if (!ieIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        OutputUtilities.newLine(sb);
        OutputUtilities.javaIndent(sb, --indentLevel);
        sb.append('}');
        return sb.toString();
    }

    public Set<FullyQualifiedJavaType> getSuperInterfaceTypes() {
        return this.superInterfaceTypes;
    }

    public void addSuperInterface(FullyQualifiedJavaType superInterface) {
        this.superInterfaceTypes.add(superInterface);
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public FullyQualifiedJavaType getType() {
        return this.type;
    }
}

