/*
 * Decompiled with CFR 0.152.
 */
package run.mone.doris;

import com.google.common.collect.Lists;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisService {
    private static final Logger log = LoggerFactory.getLogger(DorisService.class);
    private HikariDataSource dataSource;
    private Map<String, ConcurrentLinkedQueue<Map<String, Object>>> bufferMap = new ConcurrentHashMap<String, ConcurrentLinkedQueue<Map<String, Object>>>();
    private Map<String, List<String>> tableMap = new ConcurrentHashMap<String, List<String>>();
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService executorService;
    private Long flushIntervalMillSeconds = 1000L;
    private Integer stream_load_port = 8030;
    private static final String DEFAULT_DRIVER_NAME = "org.mariadb.jdbc.Driver";

    public DorisService(String url, String user, String password) {
        this(DEFAULT_DRIVER_NAME, url, user, password);
    }

    public DorisService(String driver, String url, String user, String password) {
        this.dataSource = this.getDatasource(driver, url, user, password);
        this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleAtFixedRate(this::flush, 1000L, this.flushIntervalMillSeconds, TimeUnit.MILLISECONDS);
    }

    private HikariDataSource getDatasource(String driver, String url, String user, String password) {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(driver);
        config.setJdbcUrl(url);
        config.setUsername(user);
        config.setPassword(password);
        config.setMaximumPoolSize(30);
        config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(30L));
        config.setConnectionTestQuery("SELECT 1");
        return new HikariDataSource(config);
    }

    public boolean createTable(String createSql) {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(createSql);
        }
        catch (SQLException e) {
            throw new RuntimeException("createTable error:" + e.getMessage());
        }
        return true;
    }

    public boolean updateTable(String updateSql) {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(updateSql);
        }
        catch (SQLException e) {
            throw new RuntimeException("updateTable error:" + e.getMessage());
        }
        return true;
    }

    public List<String> getColumnList(String tableName) {
        ArrayList columnList = Lists.newArrayList();
        try {
            Connection connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(null, null, tableName, null);){
                while (resultSet.next()) {
                    String columnName = resultSet.getString("COLUMN_NAME");
                    columnList.add(columnName);
                }
            }
        }
        catch (Exception e) {
            log.error("getColumnList error,tableName:{}", (Object)tableName, (Object)e);
        }
        return columnList;
    }

    public boolean deleteTable(String deleteSql) {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(deleteSql);
        }
        catch (SQLException e) {
            throw new RuntimeException("deleteTable error:" + e.getMessage());
        }
        return true;
    }

    private void processBatch(Connection connection, String tableName, List<String> columnList, List<Map<String, Object>> data) throws SQLException {
        String columns = columnList.stream().collect(Collectors.joining(","));
        String placeholders = columnList.stream().map(column -> "?").collect(Collectors.joining(","));
        String insertSql = String.format("INSERT INTO %s (%s) VALUES(%s)", tableName, columns, placeholders);
        connection.setAutoCommit(false);
        try (PreparedStatement preparedStatement = connection.prepareStatement(insertSql);){
            int batchSize = 1000;
            int count = 1;
            for (Map<String, Object> eventLog : data) {
                for (int i = 0; i < columnList.size(); ++i) {
                    preparedStatement.setObject(i + 1, eventLog.get(columnList.get(i)));
                }
                preparedStatement.addBatch();
                if (count % batchSize == 0 || count == data.size()) {
                    int[] result = preparedStatement.executeBatch();
                    connection.commit();
                }
                ++count;
            }
            log.info("processBatch add end,count:{}", (Object)count);
        }
        catch (SQLException e) {
            connection.rollback();
            log.error("Doris insertSql execute error", (Throwable)e);
        }
        catch (Exception e) {
            log.error("processBatch exception", (Throwable)e);
        }
        catch (Throwable e) {
            log.error("processBatch Throwable", e);
        }
    }

    public Boolean send(String tableName, List<String> columnList, Map<String, Object> data) throws Exception {
        if (data == null || data.isEmpty()) {
            return false;
        }
        this.tableMap.putIfAbsent(tableName, columnList);
        boolean offer = this.bufferMap.computeIfAbsent(tableName, k -> new ConcurrentLinkedQueue()).offer(data);
        log.info("data key:{},data size:{},insert res:{}", new Object[]{tableName, this.bufferMap.get(tableName).size(), offer});
        return offer;
    }

    public void flush() {
        try {
            for (Map.Entry<String, ConcurrentLinkedQueue<Map<String, Object>>> buffersEntry : this.bufferMap.entrySet()) {
                if (buffersEntry.getValue().isEmpty()) continue;
                this.executorService.submit(() -> {
                    long startTime = System.nanoTime();
                    Connection connection = null;
                    try {
                        Map data;
                        connection = this.dataSource.getConnection();
                        log.info("dataSource Active Connections:{}", (Object)this.dataSource.getHikariPoolMXBean().getActiveConnections());
                        log.info("Threads Awaiting Connection: {}", (Object)this.dataSource.getHikariPoolMXBean().getThreadsAwaitingConnection());
                        long endTime = System.nanoTime();
                        long elapsedTimeInMilliseconds = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
                        log.info("get the time it took to connect to the database\uff1a" + elapsedTimeInMilliseconds + " \u6beb\u79d2");
                        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
                        int bufferBatchSize = 10000;
                        while ((data = (Map)((ConcurrentLinkedQueue)buffersEntry.getValue()).poll()) != null) {
                            batch.add(data);
                            if (batch.size() % bufferBatchSize != 0) continue;
                            this.processBatch(connection, (String)buffersEntry.getKey(), this.tableMap.get(buffersEntry.getKey()), batch);
                            batch.clear();
                        }
                        if (!batch.isEmpty()) {
                            this.processBatch(connection, (String)buffersEntry.getKey(), this.tableMap.get(buffersEntry.getKey()), batch);
                        }
                    }
                    catch (Exception e) {
                        log.error("dories flush error", (Throwable)e);
                    }
                    finally {
                        if (null != connection) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                log.error("connection close error", (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("flush error", (Throwable)e);
        }
    }

    public List<Map<String, Object>> query(String querySql) throws SQLException {
        ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(querySql);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    dataMap.put(metaData.getColumnName(i), resultSet.getObject(i));
                }
                columns.add(dataMap);
            }
        }
        return columns;
    }

    public void setStream_load_port(Integer stream_load_port) {
        this.stream_load_port = stream_load_port;
    }
}

