/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.handler;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.xiaomi.data.push.client.HttpClientV6;
import com.xiaomi.youpin.docean.anno.Component;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ozhera.operator.bo.HeraBootstrap;
import org.apache.ozhera.operator.bo.HeraBootstrapList;
import org.apache.ozhera.operator.bo.HeraResource;
import org.apache.ozhera.operator.bo.HeraSpec;
import org.apache.ozhera.operator.bo.HeraStatus;
import org.apache.ozhera.operator.bo.PropConf;
import org.apache.ozhera.operator.common.K8sUtilBean;
import org.apache.ozhera.operator.common.ResourceTypeEnum;
import org.apache.ozhera.operator.service.ESService;
import org.apache.ozhera.operator.service.RocketMQService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="HeraResourceEventHandler")
public class HeraResourceEventHandler
implements ResourceEventHandler<HeraBootstrap> {
    private static final Logger log = LoggerFactory.getLogger(HeraResourceEventHandler.class);
    @Resource
    private KubernetesClient kubernetesClient;
    @Resource(name="heraClient")
    private MixedOperation<HeraBootstrap, HeraBootstrapList, io.fabric8.kubernetes.client.dsl.Resource<HeraBootstrap>> heraClient;
    @Resource(name="deploymentClient")
    private MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> deploymentClient;
    @Resource(name="serviceClient")
    private MixedOperation<Service, ServiceList, io.fabric8.kubernetes.client.dsl.Resource<Service>> serviceClient;
    @Resource(name="pvClient")
    private MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, io.fabric8.kubernetes.client.dsl.Resource<PersistentVolumeClaim>> pvClient;
    @Resource
    private ESService esService;
    @Resource
    private RocketMQService rocketMQSerivce;
    @Resource
    private K8sUtilBean k8sUtilBean;
    private Gson gson = new Gson();

    public void onAdd(HeraBootstrap heraBootstrap) {
        try {
            Preconditions.checkArgument((null != heraBootstrap ? 1 : 0) != 0);
            Preconditions.checkArgument((null != heraBootstrap.getSpec() ? 1 : 0) != 0);
            Preconditions.checkArgument((null != heraBootstrap.getMetadata() ? 1 : 0) != 0);
            log.info("### on add hera{}", (Object)heraBootstrap);
            if (null != heraBootstrap.getStatus() && 1 == ((HeraStatus)heraBootstrap.getStatus()).getStatus()) {
                log.warn("### HERA platform initialized, no need to init again");
                return;
            }
            HeraSpec heraSpec = (HeraSpec)heraBootstrap.getSpec();
            ObjectMeta objectMeta = heraBootstrap.getMetadata();
            List<HeraResource> heraResourceList = heraSpec.getResourceList();
            TreeMap groupHrList = heraResourceList.stream().collect(Collectors.groupingBy(h -> ResourceTypeEnum.typeOf((String)h.getResourceType()).getOrder(), TreeMap::new, Collectors.toList()));
            int step = 10;
            for (Map.Entry entrySet : groupHrList.entrySet()) {
                List hrList = (List)entrySet.getValue();
                log.warn("hera operator add, applyResource resourceType:{}, HeraResource size:{}", entrySet.getKey(), (Object)hrList.size());
                for (HeraResource heraResource : hrList) {
                    this.k8sUtilBean.applyResource(heraResource, objectMeta, "add");
                }
                TimeUnit.SECONDS.sleep(step--);
                this.block2checkStatus(objectMeta);
                for (HeraResource heraResource : hrList) {
                    HashMap newMap;
                    if (ResourceTypeEnum.Nacos.getTypeName().equals(heraResource.getResourceType())) {
                        Preconditions.checkArgument((null != heraResource.getConnectionMapList() ? 1 : 0) != 0, (Object)"nacos connection kv config can not be null");
                        newMap = new HashMap();
                        heraResource.getConnectionMapList().forEach(map -> newMap.put((String)map.get("key"), (String)map.get("value")));
                        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)newMap.get("hera.nacos.address"))), (Object)String.format("nacos connection config:%s can not be null", "hera.nacos.address"));
                        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)newMap.get("hera.nacos.password"))), (Object)String.format("nacos connection config:%s can not be null", "hera.nacos.password"));
                        this.initNacos("add", (String)newMap.get("hera.nacos.address"), (String)newMap.get("hera.nacos.password"), heraResource.getPropList());
                    }
                    if (ResourceTypeEnum.ES.getTypeName().equals(heraResource.getResourceType())) {
                        Preconditions.checkArgument((null != heraResource.getConnectionMapList() ? 1 : 0) != 0, (Object)"es connection kv config can not be null");
                        newMap = new HashMap();
                        heraResource.getConnectionMapList().forEach(map -> newMap.put((String)map.get("key"), (String)map.get("value")));
                        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)newMap.get("hera.es.url"))), (Object)String.format("es connection config:%s can not be null", "hera.es.url"));
                        this.initES((String)newMap.get("hera.es.url"), (String)newMap.get("hera.es.username"), (String)newMap.get("hera.es.password"));
                    }
                    if (ResourceTypeEnum.MYSQL.getTypeName().equals(heraResource.getResourceType())) {
                        Preconditions.checkArgument((null != heraResource.getConnectionMapList() ? 1 : 0) != 0, (Object)"mysql connection kv config can not be null");
                        newMap = new HashMap();
                        heraResource.getConnectionMapList().forEach(map -> newMap.put((String)map.get("key"), (String)map.get("value")));
                        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)newMap.get("hera.datasource.url"))), (Object)String.format("mysql connection config:%s can not be null", "hera.datasource.url"));
                        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)newMap.get("hera.datasource.username"))), (Object)String.format("es connection config:%s can not be null", "hera.datasource.username"));
                        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)newMap.get("hera.datasource.password"))), (Object)String.format("es connection config:%s can not be null", "hera.datasource.password"));
                        this.initSql("add", (String)newMap.get("hera.datasource.url"), (String)newMap.get("hera.datasource.username"), (String)newMap.get("hera.datasource.password"));
                    }
                    if (!ResourceTypeEnum.ROCKETMQ.getTypeName().equals(heraResource.getResourceType())) continue;
                    Preconditions.checkArgument((null != heraResource.getConnectionMapList() ? 1 : 0) != 0, (Object)"rocketmq connection kv config can not be null");
                    newMap = new HashMap();
                    heraResource.getConnectionMapList().forEach(map -> newMap.put((String)map.get("key"), (String)map.get("value")));
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)newMap.get("hera.rocketmq.nameserver"))), (Object)String.format("rocketmq nameserver config:%s can not be null", "hera.rocketmq.nameserver"));
                    this.initRocketMQ((String)newMap.get("hera.rocketmq.nameserver"));
                }
            }
            HeraStatus heraStatus = new HeraStatus();
            heraStatus.setStatus(1);
            heraStatus.setMsg("success");
            heraBootstrap.setStatus(heraStatus);
            this.heraClient.patchStatus((Object)heraBootstrap);
            log.warn("hera operator onAdd success");
        }
        catch (Throwable e) {
            log.error("hera operator onAdd error:", e);
            HeraStatus heraStatus = new HeraStatus();
            heraStatus.setStatus(-1);
            heraStatus.setMsg(ExceptionUtils.getStackTrace((Throwable)e));
            heraBootstrap.setStatus(heraStatus);
            this.heraClient.patchStatus((Object)heraBootstrap);
        }
    }

    private void block2checkStatus(ObjectMeta objectMeta) throws InterruptedException {
        String namespace = objectMeta.getNamespace();
        for (int i = 0; i < 100; ++i) {
            boolean ready = true;
            DeploymentList deploymentList = (DeploymentList)((NonNamespaceOperation)this.deploymentClient.inNamespace(namespace)).list();
            List list = deploymentList.getItems();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            for (Deployment deployment : list) {
                Integer readyReplicas;
                String deploymentName = deployment.getMetadata().getName();
                Integer replicas = deployment.getStatus().getReplicas();
                if (replicas == (readyReplicas = deployment.getStatus().getReadyReplicas())) continue;
                ready = false;
                log.warn("deployment:{} not ready, getReplicas:{}, ReadyReplicas:{}", new Object[]{deploymentName, replicas, readyReplicas});
            }
            if (ready) {
                TimeUnit.SECONDS.sleep(15L);
                return;
            }
            TimeUnit.SECONDS.sleep(i + 2);
        }
        throw new RuntimeException("deployment not ready, after retry 15 times, break");
    }

    private void initTpc(String action) {
        String url = "http://tpc-mone-b2c-srv:8097/tpc/init";
        int retryTimes = 9;
        Object con = null;
        while (retryTimes-- > 0) {
            try {
                String init = HttpClientV6.get((String)url, new HashMap(), (int)2000);
                log.error("tpc init result:{}", (Object)init);
                if (init.contains("ConnectException")) {
                    throw new RuntimeException(init);
                }
                break;
            }
            catch (Exception e) {
                log.error("tpc init error retryTimes:{}", (Object)retryTimes, (Object)e);
                try {
                    TimeUnit.SECONDS.sleep(17L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void initNacos(String action, String nacosAddress, String pwd, List<PropConf> propConfList) throws InterruptedException {
        log.warn("initNacos begin nacosAddress:{}", (Object)nacosAddress);
        Thread.sleep(30000L);
        String url = String.format("http://%s/nacos/v1/ns/cluster/enable?level=4&pwd=%s", nacosAddress, pwd);
        String nacosEnable = HttpClientV6.get((String)url, new HashMap(), (int)2000);
        if (!"ok".equals(nacosEnable)) {
            log.error("nacos cluster enable failed:{}", (Object)nacosEnable);
        } else {
            log.error("nacos cluster enable success");
        }
        String nacosCfApi = String.format("http://%s/nacos/v1/cs/configs", nacosAddress);
        block4: for (PropConf propConf : propConfList) {
            int retryTimes = 3;
            Object con = null;
            while (retryTimes-- > 0) {
                try {
                    String content = propConf.getValue();
                    String eContent = URLEncoder.encode(content, "UTF-8");
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("Content-Type", "application/x-www-form-urlencoded");
                    headers.put("charset", "utf-8");
                    String key = propConf.getKey();
                    String dataId = key.substring(0, key.indexOf("_#_"));
                    String group = key.substring(key.indexOf("_#_") + 3);
                    String body = String.format("type=%s&dataId=%s&group=%s&content=%s", "properties", dataId, group, eContent);
                    log.info("create nacos config file:{}", (Object)body);
                    String result = HttpClientV6.post((String)nacosCfApi, (String)body, headers, (int)3000);
                    if (!"true".equals(result)) {
                        log.error("create nacos config file failed:{}", (Object)result);
                        continue block4;
                    }
                    log.info("create nacos config file success");
                    continue block4;
                }
                catch (IOException e) {
                    log.error("nacos init error retryTimes:{}", (Object)retryTimes, (Object)e);
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private void initSql(String action, String url, String userName, String pwd) {
        Object[] scripts = new String[]{"/ozhera_init/mysql/sql/nacos.sql", "/ozhera_init/mysql/sql/tpc.sql", "/ozhera_init/mysql/sql/grafana.sql", "/ozhera_init/mysql/sql/hera.sql"};
        log.warn("sql scripts:{}", scripts);
        this.executeSqlScript((String[])scripts, url, userName, pwd);
        log.warn("sql scripts execute success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlScript(String[] scripts, String url, String userName, String pwd) {
        int retryTimes = 3;
        Connection con = null;
        ScriptRunner sr = null;
        try {
            DriverManager.registerDriver((Driver)new com.mysql.cj.jdbc.Driver());
        }
        catch (SQLException e) {
            log.error("Driver registration failed: {}", (Object)e.getMessage());
            return;
        }
        while (retryTimes-- > 0) {
            try {
                String mariadbUrl = String.format("jdbc:mysql://%s/?useUnicode=true&characterEncoding=utf8&useSSL=false&connectTimeout=4000&socketTimeout=60000", url);
                con = DriverManager.getConnection(mariadbUrl, userName, pwd);
                log.warn("Connection established :{}", (Object)mariadbUrl);
                for (String sqlFile : scripts) {
                    sr = new ScriptRunner(con);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(sqlFile)));
                    sr.runScript((Reader)reader);
                    ((Reader)reader).close();
                }
                break;
            }
            catch (SQLException e) {
                log.error("SQLException:{}, retryTimes:{}", (Object)e.getMessage(), (Object)retryTimes);
                try {
                    TimeUnit.SECONDS.sleep(15L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                log.error("sql execute error", (Throwable)e);
                break;
            }
            finally {
                if (sr != null) {
                    sr.closeConnection();
                }
                if (con == null) continue;
                try {
                    con.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
    }

    private void initES(String url, String userName, String pwd) {
        this.esService.createESTemplate(url, userName, pwd);
    }

    private void initRocketMQ(String nameserver) {
        this.rocketMQSerivce.createTopic(nameserver);
    }

    public void onUpdate(HeraBootstrap oldObj, HeraBootstrap newObj) {
        log.info("####onUpdate hera xxx");
    }

    public void onDelete(HeraBootstrap heraBootstrap, boolean deletedFinalStateUnknown) {
        log.info("delete mone:{}", heraBootstrap.getSpec());
        try {
            log.info("### on delete hera{}", (Object)heraBootstrap);
            HeraSpec heraSpec = (HeraSpec)heraBootstrap.getSpec();
            ObjectMeta objectMeta = heraBootstrap.getMetadata();
            List<HeraResource> heraResourceList = heraSpec.getResourceList();
            for (HeraResource heraResource : heraResourceList) {
                try {
                    this.k8sUtilBean.applyResource(heraResource, objectMeta, "delete");
                }
                catch (Exception e) {
                    log.warn("heraResource:{} delete error", (Object)heraResource.getResourceName(), (Object)e);
                }
            }
        }
        catch (Throwable e) {
            log.error("hera operator onAdd error:", e);
        }
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public MixedOperation<HeraBootstrap, HeraBootstrapList, io.fabric8.kubernetes.client.dsl.Resource<HeraBootstrap>> getHeraClient() {
        return this.heraClient;
    }

    public MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> getDeploymentClient() {
        return this.deploymentClient;
    }

    public MixedOperation<Service, ServiceList, io.fabric8.kubernetes.client.dsl.Resource<Service>> getServiceClient() {
        return this.serviceClient;
    }

    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, io.fabric8.kubernetes.client.dsl.Resource<PersistentVolumeClaim>> getPvClient() {
        return this.pvClient;
    }

    public ESService getEsService() {
        return this.esService;
    }

    public RocketMQService getRocketMQSerivce() {
        return this.rocketMQSerivce;
    }

    public K8sUtilBean getK8sUtilBean() {
        return this.k8sUtilBean;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setKubernetesClient(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public void setHeraClient(MixedOperation<HeraBootstrap, HeraBootstrapList, io.fabric8.kubernetes.client.dsl.Resource<HeraBootstrap>> heraClient) {
        this.heraClient = heraClient;
    }

    public void setDeploymentClient(MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> deploymentClient) {
        this.deploymentClient = deploymentClient;
    }

    public void setServiceClient(MixedOperation<Service, ServiceList, io.fabric8.kubernetes.client.dsl.Resource<Service>> serviceClient) {
        this.serviceClient = serviceClient;
    }

    public void setPvClient(MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, io.fabric8.kubernetes.client.dsl.Resource<PersistentVolumeClaim>> pvClient) {
        this.pvClient = pvClient;
    }

    public void setEsService(ESService esService) {
        this.esService = esService;
    }

    public void setRocketMQSerivce(RocketMQService rocketMQSerivce) {
        this.rocketMQSerivce = rocketMQSerivce;
    }

    public void setK8sUtilBean(K8sUtilBean k8sUtilBean) {
        this.k8sUtilBean = k8sUtilBean;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeraResourceEventHandler)) {
            return false;
        }
        HeraResourceEventHandler other = (HeraResourceEventHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KubernetesClient this$kubernetesClient = this.getKubernetesClient();
        KubernetesClient other$kubernetesClient = other.getKubernetesClient();
        if (this$kubernetesClient == null ? other$kubernetesClient != null : !this$kubernetesClient.equals(other$kubernetesClient)) {
            return false;
        }
        MixedOperation<HeraBootstrap, HeraBootstrapList, io.fabric8.kubernetes.client.dsl.Resource<HeraBootstrap>> this$heraClient = this.getHeraClient();
        MixedOperation<HeraBootstrap, HeraBootstrapList, io.fabric8.kubernetes.client.dsl.Resource<HeraBootstrap>> other$heraClient = other.getHeraClient();
        if (this$heraClient == null ? other$heraClient != null : !this$heraClient.equals(other$heraClient)) {
            return false;
        }
        MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> this$deploymentClient = this.getDeploymentClient();
        MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> other$deploymentClient = other.getDeploymentClient();
        if (this$deploymentClient == null ? other$deploymentClient != null : !this$deploymentClient.equals(other$deploymentClient)) {
            return false;
        }
        MixedOperation<Service, ServiceList, io.fabric8.kubernetes.client.dsl.Resource<Service>> this$serviceClient = this.getServiceClient();
        MixedOperation<Service, ServiceList, io.fabric8.kubernetes.client.dsl.Resource<Service>> other$serviceClient = other.getServiceClient();
        if (this$serviceClient == null ? other$serviceClient != null : !this$serviceClient.equals(other$serviceClient)) {
            return false;
        }
        MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, io.fabric8.kubernetes.client.dsl.Resource<PersistentVolumeClaim>> this$pvClient = this.getPvClient();
        MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, io.fabric8.kubernetes.client.dsl.Resource<PersistentVolumeClaim>> other$pvClient = other.getPvClient();
        if (this$pvClient == null ? other$pvClient != null : !this$pvClient.equals(other$pvClient)) {
            return false;
        }
        ESService this$esService = this.getEsService();
        ESService other$esService = other.getEsService();
        if (this$esService == null ? other$esService != null : !this$esService.equals(other$esService)) {
            return false;
        }
        RocketMQService this$rocketMQSerivce = this.getRocketMQSerivce();
        RocketMQService other$rocketMQSerivce = other.getRocketMQSerivce();
        if (this$rocketMQSerivce == null ? other$rocketMQSerivce != null : !this$rocketMQSerivce.equals(other$rocketMQSerivce)) {
            return false;
        }
        K8sUtilBean this$k8sUtilBean = this.getK8sUtilBean();
        K8sUtilBean other$k8sUtilBean = other.getK8sUtilBean();
        if (this$k8sUtilBean == null ? other$k8sUtilBean != null : !this$k8sUtilBean.equals(other$k8sUtilBean)) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        return !(this$gson == null ? other$gson != null : !this$gson.equals(other$gson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeraResourceEventHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KubernetesClient $kubernetesClient = this.getKubernetesClient();
        result = result * 59 + ($kubernetesClient == null ? 43 : $kubernetesClient.hashCode());
        MixedOperation<HeraBootstrap, HeraBootstrapList, io.fabric8.kubernetes.client.dsl.Resource<HeraBootstrap>> $heraClient = this.getHeraClient();
        result = result * 59 + ($heraClient == null ? 43 : $heraClient.hashCode());
        MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> $deploymentClient = this.getDeploymentClient();
        result = result * 59 + ($deploymentClient == null ? 43 : $deploymentClient.hashCode());
        MixedOperation<Service, ServiceList, io.fabric8.kubernetes.client.dsl.Resource<Service>> $serviceClient = this.getServiceClient();
        result = result * 59 + ($serviceClient == null ? 43 : $serviceClient.hashCode());
        MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, io.fabric8.kubernetes.client.dsl.Resource<PersistentVolumeClaim>> $pvClient = this.getPvClient();
        result = result * 59 + ($pvClient == null ? 43 : $pvClient.hashCode());
        ESService $esService = this.getEsService();
        result = result * 59 + ($esService == null ? 43 : $esService.hashCode());
        RocketMQService $rocketMQSerivce = this.getRocketMQSerivce();
        result = result * 59 + ($rocketMQSerivce == null ? 43 : $rocketMQSerivce.hashCode());
        K8sUtilBean $k8sUtilBean = this.getK8sUtilBean();
        result = result * 59 + ($k8sUtilBean == null ? 43 : $k8sUtilBean.hashCode());
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        return result;
    }

    public String toString() {
        return "HeraResourceEventHandler(kubernetesClient=" + String.valueOf(this.getKubernetesClient()) + ", heraClient=" + String.valueOf(this.getHeraClient()) + ", deploymentClient=" + String.valueOf(this.getDeploymentClient()) + ", serviceClient=" + String.valueOf(this.getServiceClient()) + ", pvClient=" + String.valueOf(this.getPvClient()) + ", esService=" + String.valueOf(this.getEsService()) + ", rocketMQSerivce=" + String.valueOf(this.getRocketMQSerivce()) + ", k8sUtilBean=" + String.valueOf(this.getK8sUtilBean()) + ", gson=" + String.valueOf(this.getGson()) + ")";
    }
}

