/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.xiaomi.youpin.docean.anno.Service;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.common.validation.StoreSpaceAuthValid;
import org.apache.ozhera.log.manager.dao.MilogStoreSpaceAuthDao;
import org.apache.ozhera.log.manager.model.bo.StoreSpaceAuth;
import org.apache.ozhera.log.manager.model.pojo.MilogStoreSpaceAuth;
import org.apache.ozhera.log.manager.service.BaseService;
import org.apache.ozhera.log.manager.service.MilogStoreSpaceAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogStoreSpaceAuthServiceImpl
extends BaseService
implements MilogStoreSpaceAuthService {
    private static final Logger log = LoggerFactory.getLogger(MilogStoreSpaceAuthServiceImpl.class);
    @Resource
    private MilogStoreSpaceAuthDao milogStoreSpaceAuthDao;
    @Resource
    private StoreSpaceAuthValid storeSpaceAuthValid;

    @Override
    public String storeSpaceAuth(StoreSpaceAuth storeSpaceAuth) {
        String paramsErrorInfos = this.storeSpaceAuthValid.validParam(storeSpaceAuth);
        if (StringUtils.isNotBlank((CharSequence)paramsErrorInfos)) {
            throw new MilogManageException(paramsErrorInfos);
        }
        String dataCollectInfos = this.storeSpaceAuthValid.validStoreAuthData(storeSpaceAuth);
        if (StringUtils.isNotBlank((CharSequence)dataCollectInfos)) {
            throw new MilogManageException(dataCollectInfos);
        }
        MilogStoreSpaceAuth milogStoreSpaceAuth = this.milogStoreSpaceAuthDao.queryByStoreSpace(storeSpaceAuth.getStoreId(), storeSpaceAuth.getSpaceId());
        if (null == milogStoreSpaceAuth) {
            MilogStoreSpaceAuth auth = this.buildStoreSpaceAuth(storeSpaceAuth.getStoreId(), storeSpaceAuth.getSpaceId());
            this.milogStoreSpaceAuthDao.add(auth);
            return "success";
        }
        this.wrapBaseCommon(milogStoreSpaceAuth, OperateEnum.UPDATE_OPERATE);
        this.milogStoreSpaceAuthDao.update(milogStoreSpaceAuth);
        return "success";
    }

    private MilogStoreSpaceAuth buildStoreSpaceAuth(Long storeId, Long spaceId) {
        MilogStoreSpaceAuth storeSpaceAuth = new MilogStoreSpaceAuth();
        storeSpaceAuth.setStoreId(storeId);
        storeSpaceAuth.setSpaceId(spaceId);
        this.wrapBaseCommon(storeSpaceAuth, OperateEnum.ADD_OPERATE);
        return storeSpaceAuth;
    }
}

