/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.resource;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.api.enums.MiddlewareEnum;
import org.apache.ozhera.log.api.model.bo.MiLogResource;
import org.apache.ozhera.log.api.model.vo.ResourceUserSimple;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogEsIndexDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="defaultResourceExtensionService")
public class DefaultResourceExtensionService
implements ResourceExtensionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceExtensionService.class);
    @Resource
    private MilogSpaceDao logSpaceDao;

    @Override
    public List<MilogMiddlewareConfig> userShowAuthority(List<MilogMiddlewareConfig> configList) {
        return configList;
    }

    @Override
    public void filterEsQueryWrapper(QueryWrapper<?> queryWrapper) {
    }

    @Override
    public List<String> generateResourceLabels(String id) {
        return Lists.newArrayList();
    }

    @Override
    public void addResourcePreProcessing(List<String> resourceLabels, MiLogResource miLogResource) {
    }

    @Override
    public void addEsResourcePreProcessing(MilogEsClusterDO esClusterDO) {
        if (MoneUserContext.getCurrentUser().getIsAdmin().booleanValue()) {
            esClusterDO.setIsDefault(Constant.YES);
        }
    }

    @Override
    public void addResourceMiddleProcessing(MiLogResource miLogResource) {
    }

    @Override
    public void addResourcePostProcessing(MilogMiddlewareConfig milogMiddlewareConfig) {
        if (MoneUserContext.getCurrentUser().getIsAdmin().booleanValue()) {
            milogMiddlewareConfig.setIsDefault(Constant.YES);
        }
    }

    @Override
    public boolean userResourceListPre(Integer logTypeCode) {
        return false;
    }

    @Override
    public List<MilogMiddlewareConfig> currentUserConfigFilter(List<MilogMiddlewareConfig> middlewareConfigs) {
        if (MoneUserContext.getCurrentUser().getIsAdmin().booleanValue()) {
            return middlewareConfigs.stream().filter(milogMiddlewareConfig -> Objects.equals(Constant.YES, milogMiddlewareConfig.getIsDefault())).collect(Collectors.toList());
        }
        return middlewareConfigs;
    }

    @Override
    public boolean resourceNotRequiredInit(Integer logTypeCode, List<MilogMiddlewareConfig> middlewareMqConfigs, List<MilogMiddlewareConfig> middlewareEsConfigs, List<MilogEsIndexDO> esIndexDOList) {
        return CollectionUtils.isNotEmpty(middlewareMqConfigs) && CollectionUtils.isNotEmpty(middlewareEsConfigs) && CollectionUtils.isNotEmpty(esIndexDOList);
    }

    @Override
    public boolean resourceShowStatusFlag(ResourceUserSimple configResource) {
        if (MoneUserContext.getCurrentUser().getIsAdmin().booleanValue()) {
            configResource.setShowFlag(Boolean.FALSE);
            return false;
        }
        configResource.setShowFlag(Boolean.TRUE);
        return Boolean.TRUE;
    }

    @Override
    public Integer getResourceCode() {
        return MiddlewareEnum.ROCKETMQ.getCode();
    }

    @Override
    public void deleteMqResourceProcessing(MilogLogTailDo mt, MilogLogStoreDO logStoreDO) {
    }

    @Override
    public List<Integer> getMqResourceCodeList() {
        return Arrays.stream(MQSourceEnum.values()).map(MQSourceEnum::getCode).collect(Collectors.toList());
    }

    @Override
    public String queryHostName(String ip) {
        return ip;
    }

    @Override
    public List<Long> getSpaceIdsByNameExcluded(String spaceName) {
        List<Long> spaceIds;
        if (StringUtils.isNotBlank((CharSequence)spaceName)) {
            List<MilogSpaceDO> spaceDOS = this.logSpaceDao.queryByName(spaceName);
            spaceIds = spaceDOS.stream().map(MilogSpaceDO::getId).toList();
        } else {
            spaceIds = this.logSpaceDao.getAll().stream().map(MilogSpaceDO::getId).collect(Collectors.toList());
        }
        return spaceIds;
    }
}

