/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.spring;

import java.lang.annotation.Annotation;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocException;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.annotation.InjectName;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.mvc.IocProvider;
import org.nutz.mvc.NutConfig;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class SpringIocProvider
implements IocProvider,
Ioc {
    protected ApplicationContext applicationContext;

    public Ioc create(NutConfig config, String[] args) {
        this.applicationContext = config == null || Lang.eleSize((Object)args) > 0 ? new ClassPathXmlApplicationContext(args) : (ApplicationContext)config.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        return this;
    }

    public void depose() {
        if (this.applicationContext != null) {
            this.applicationContext.publishEvent((ApplicationEvent)new ContextClosedEvent(this.applicationContext));
            this.applicationContext = null;
        }
    }

    public <T> T get(Class<T> type, String name) {
        return (T)this.applicationContext.getBean(name, type);
    }

    public String[] getNames() {
        return this.applicationContext.getBeanDefinitionNames();
    }

    public boolean has(String name) {
        return this.applicationContext.containsBean(name);
    }

    public void reset() {
        this.applicationContext.publishEvent((ApplicationEvent)new ContextRefreshedEvent(this.applicationContext));
    }

    public <T> T get(Class<T> classZ) throws IocException {
        InjectName injectName = classZ.getAnnotation(InjectName.class);
        if (injectName != null && !Strings.isBlank((CharSequence)injectName.value())) {
            return (T)this.applicationContext.getBean(injectName.value());
        }
        return (T)this.applicationContext.getBean(this.applicationContext.getBeanNamesForType(classZ)[0]);
    }

    public String[] getNamesByType(Class<?> klass) {
        return this.applicationContext.getBeanDefinitionNames();
    }

    public <K> K getByType(Class<K> klass) {
        return (K)this.applicationContext.getBean(klass);
    }

    public String[] getNamesByAnnotation(Class<? extends Annotation> klass) {
        return this.applicationContext.getBeanNamesForAnnotation(klass);
    }

    public Ioc addBean(String name, Object obj) {
        if (this instanceof SingletonBeanRegistry) {
            ((SingletonBeanRegistry)this).registerSingleton(name, obj);
        }
        return this;
    }

    public Class<?> getType(String name) throws ObjectLoadException {
        return this.applicationContext.getType(name);
    }
}

