/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;

class FieldReaderStringField<T>
extends FieldReaderObjectField<T> {
    final boolean trim;
    final long fieldOffset;

    FieldReaderStringField(String fieldName, Class fieldType, int ordinal, long features, String format, String defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
        this.trim = "trim".equals(format) || (features & JSONReader.Feature.TrimString.mask) != 0L;
        this.fieldOffset = JDKUtils.UNSAFE_SUPPORT ? UnsafeUtils.objectFieldOffset(field) : 0L;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        String fieldValue = jsonReader.readString();
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        if (this.schema != null) {
            this.schema.assertValidate(fieldValue);
        }
        if (JDKUtils.UNSAFE_SUPPORT) {
            UnsafeUtils.UNSAFE.putObject(object, this.fieldOffset, fieldValue);
        } else {
            try {
                this.field.set(object, fieldValue);
            }
            catch (Exception e) {
                throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
            }
        }
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        String fieldValue = jsonReader.readString();
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        if (this.schema != null) {
            this.schema.assertValidate(fieldValue);
        }
        this.accept(object, fieldValue);
    }

    @Override
    public String readFieldValue(JSONReader jsonReader) {
        String fieldValue = jsonReader.readString();
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        return fieldValue;
    }

    @Override
    public boolean supportAcceptType(Class valueClass) {
        return true;
    }

    @Override
    public void accept(T object, Object value) {
        String fieldValue = value != null && !(value instanceof String) ? value.toString() : (String)value;
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        if (this.schema != null) {
            this.schema.assertValidate(fieldValue);
        }
        if (JDKUtils.UNSAFE_SUPPORT) {
            UnsafeUtils.UNSAFE.putObject(object, this.fieldOffset, fieldValue);
        } else {
            try {
                this.field.set(object, fieldValue);
            }
            catch (Exception e) {
                throw new JSONException("set " + this.fieldName + " error", e);
            }
        }
    }
}

