/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.all.client;

import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.ozhera.prometheus.all.client.Prometheus;
import org.apache.ozhera.prometheus.all.client.XmCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusCounter
implements XmCounter {
    private static final Logger log = LoggerFactory.getLogger(PrometheusCounter.class);
    public String[] labelValues;
    public Counter myCounter;
    public String[] labelNames;

    public PrometheusCounter(Counter cb, String[] lns, String[] lvs) {
        this.myCounter = cb;
        this.labelNames = lns;
        this.labelValues = lvs;
    }

    public PrometheusCounter() {
    }

    @Override
    public XmCounter with(String ... labelValues) {
        try {
            if (this.labelNames.length != labelValues.length) {
                log.warn("Incorrect numbers of labels : " + ((Collector.MetricFamilySamples)this.myCounter.describe().get((int)0)).name + " labelName: " + this.labelNames.length + " labelValues: " + labelValues.length + "{} {}", (Object)Arrays.toString(this.labelNames), (Object)Arrays.toString(labelValues));
                return new PrometheusCounter();
            }
            return this;
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
            return null;
        }
    }

    @Override
    public void add(double delta, String ... labelValues) {
        ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelValues));
        mylist.add(Prometheus.constLabels.get("service"));
        String[] finalValue = mylist.toArray(new String[mylist.size()]);
        try {
            ((Counter.Child)this.myCounter.labels(finalValue)).inc(delta);
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
        }
    }
}

