/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.kafka;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.ozhera.trace.etl.bo.MqConfig;
import org.apache.ozhera.trace.etl.extension.kafka.KafkaConfigure;

public class KafkaConfigure9092
implements KafkaConfigure {
    @NacosValue(value="${kafka.poll.records}")
    private int kafkaPollRecords;

    @Override
    public Properties createProducerProperties(MqConfig<ConsumerRecords<String, String>> config) {
        Properties props = new Properties();
        props.put("bootstrap.servers", config.getNameSerAddr());
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("max.block.ms", (Object)30000);
        props.put("retries", (Object)5);
        props.put("reconnect.backoff.ms", (Object)3000);
        return props;
    }

    @Override
    public Properties createConsumerProperties(MqConfig<ConsumerRecords<String, String>> config) {
        Properties props = new Properties();
        props.put("bootstrap.servers", config.getNameSerAddr());
        props.put("session.timeout.ms", (Object)30000);
        props.put("max.poll.records", (Object)this.kafkaPollRecords);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("group.id", config.getConsumerGroup());
        return props;
    }
}

