/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.helper;

import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.log.api.model.dto.MontorAppDTO;
import org.apache.ozhera.log.api.service.MilogOpenService;
import org.apache.ozhera.monitor.bo.PlatForm;
import org.apache.ozhera.monitor.dao.AppMonitorDao;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectHelper {
    private static final Logger log = LoggerFactory.getLogger(ProjectHelper.class);
    @Reference(check=false, interfaceClass=MilogOpenService.class, group="${dubbo.group}")
    private MilogOpenService milogOpenService;
    @Autowired
    private AppMonitorDao appMonitorDao;
    @Autowired
    private PlatFormTypeExtensionService platFormTypeExtensionService;

    public boolean accessLogSys(String projectName, Long projectId, Integer appSource) {
        log.info("\u67e5\u8be2\u8be6\u60c5\u662f\u5426\u5165\u4f4f\u65e5\u5fd7\u7cfb\u7edf\u8bf7\u6c42 projectName={}, projectId={}", (Object)projectName, (Object)projectId);
        if (StringUtils.isBlank((CharSequence)projectName) || projectId == null) {
            return true;
        }
        if (this.platFormTypeExtensionService.belongPlatForm(appSource, PlatForm.miCloud)) {
            return true;
        }
        AppMonitor app = this.appMonitorDao.getByAppIdAndName(projectId.intValue(), projectName);
        if (app == null) {
            log.info("\u67e5\u8be2\u8be6\u60c5\u662f\u5426\u5165\u4f4f\u65e5\u5fd7\u7cfb\u7edf\u8bf7\u6c42\uff0c\u6ca1\u6709app\u4fe1\u606f; projectId={}, projectName={}", (Object)projectId, (Object)projectName);
            return true;
        }
        try {
            MontorAppDTO result = this.milogOpenService.queryHaveAccessMilog(Long.valueOf(app.getIamTreeId().longValue()), String.valueOf(projectId), appSource);
            log.info("\u67e5\u8be2\u8be6\u60c5\u662f\u5426\u5165\u4f4f\u65e5\u5fd7\u7cfb\u7edf\u8bf7\u6c42iamId:{},projectId:{},appSource:{},\u54cd\u5e94 result={}", new Object[]{app.getIamTreeId(), projectId, appSource, result});
            if (result == null) {
                return false;
            }
            return result.getIsAccess();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9879\u76ee\u662f\u5426\u5165\u4f4f\u65e5\u5fd7\u7cfb\u7edf\u5f02\u5e38; app={}", (Object)app, (Object)e);
            return true;
        }
    }
}

