/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.helper;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmCheckDataCount;
import org.apache.ozhera.monitor.bo.AlarmSendInterval;
import org.apache.ozhera.monitor.bo.AlertGroupInfo;
import org.apache.ozhera.monitor.bo.AlertHistory;
import org.apache.ozhera.monitor.bo.AlertHistoryDetailed;
import org.apache.ozhera.monitor.bo.AlertHistoryParam;
import org.apache.ozhera.monitor.bo.UserInfo;
import org.apache.ozhera.monitor.dao.model.AlertGroup;
import org.apache.ozhera.monitor.dao.model.AlertGroupMember;
import org.apache.ozhera.monitor.pojo.ReqErrorMetricsPOJO;
import org.apache.ozhera.monitor.pojo.ReqSlowMetricsPOJO;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.api.AlertHelperExtension;
import org.apache.ozhera.monitor.service.api.ReqErrorMetricsService;
import org.apache.ozhera.monitor.service.api.ReqSlowMetricsService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.alarm.duty.DutyInfo;
import org.apache.ozhera.monitor.service.prometheus.AlarmService;
import org.apache.ozhera.monitor.utils.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AlertHelper {
    private static final Logger log = LoggerFactory.getLogger(AlertHelper.class);
    private final long TEN_MINUTES = 600000L;
    private final long FIVE_MINUTES = 600000000L;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private AlertHelperExtension alertHelperExtension;
    @Autowired
    private ReqErrorMetricsService reqErrorMetricsService;
    @Autowired
    private ReqSlowMetricsService reqSlowMetricsService;
    @NacosValue(value="${hera.url}", autoRefreshed=true)
    private String heraUrl;

    public Integer queryAlertEventNum(Integer projectId, Integer treeId, Long startTime, Long endTime) {
        try {
            JsonObject labels = new JsonObject();
            labels.addProperty("project_id", projectId.toString());
            HashSet<Integer> treeIdSet = new HashSet<Integer>();
            treeIdSet.add(treeId);
            Result<PageData> result = this.alarmService.queryLatestEvents(treeIdSet, "firing", null, startTime, endTime, 1, 1, labels);
            if (result == null || result.getData() == null || ((PageData)result.getData()).getTotal() == null) {
                return 0;
            }
            return ((PageData)result.getData()).getTotal().intValue();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6700\u8fd1\u544a\u8b66\u4e8b\u4ef6\u5f02\u5e38 projectId={}", (Object)projectId, (Object)e);
            return 0;
        }
    }

    public JsonObject buildLabels(AlertHistoryParam param) {
        JsonObject labels = new JsonObject();
        if (StringUtils.isNotBlank((CharSequence)param.getServerIp())) {
            labels.addProperty("serverIp", param.getServerIp());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getInstance())) {
            labels.addProperty("instance", param.getInstance());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getMethodName())) {
            labels.addProperty("methodName", param.getMethodName());
        }
        return labels;
    }

    public List<AlertHistory> buildAlertHistoryList(JsonElement list) {
        if (list == null || !list.isJsonArray()) {
            return null;
        }
        ArrayList<AlertHistory> historyList = new ArrayList<AlertHistory>();
        list.getAsJsonArray().forEach(ele -> {
            ReqErrorMetricsPOJO errMetrics;
            JsonObject data = ele.getAsJsonObject();
            AlertHistory history = new AlertHistory();
            historyList.add(history);
            if (data.has("id")) {
                history.setId(data.get("id").getAsString());
            }
            if (data.has("alert_id")) {
                history.setAlertId(data.get("alert_id").getAsString());
            }
            if (data.has("tree_id")) {
                history.setIamTreeId(data.get("tree_id").getAsInt());
            }
            if (data.has("alert_name")) {
                history.setAlertName(data.get("alert_name").getAsString());
            }
            if (data.has("alert_cname")) {
                history.setAlertCName(data.get("alert_cname").getAsString());
            }
            if (data.has("alert_time")) {
                history.setAlertDate(CommonUtil.toMillis((Long)data.get("alert_time").getAsLong()));
            } else {
                history.setAlertDate(System.currentTimeMillis());
            }
            if (data.has("priority")) {
                history.setAlertLevel(data.get("priority").getAsString());
            }
            if (data.has("start_time")) {
                history.setStartTime(CommonUtil.toMillis((Long)data.get("start_time").getAsLong()));
            }
            if (data.has("end_time")) {
                history.setEndTime(CommonUtil.toMillis((Long)data.get("end_time").getAsLong()));
            }
            if (data.has("status")) {
                history.setAlertStat(data.get("status").getAsString());
            }
            history.setDurationTime(this.buildDurationTime(data));
            StringBuilder url = new StringBuilder();
            if (data.has("labels")) {
                JsonObject labels = data.get("labels").getAsJsonObject();
                StringBuilder content = new StringBuilder();
                this.buildAlertContent(content, labels);
                this.buildDataCountContent(content, labels);
                this.buildAlarmSendInterval(content, labels);
                history.setAlertContent(content.toString());
                if (labels.has("project_name")) {
                    history.setAlertApp(labels.get("project_name").getAsString());
                }
                if (labels.has("project_id")) {
                    history.setAlertAppId(labels.get("project_id").getAsString());
                }
                if (labels.has("instance")) {
                    history.setAlertIntance(labels.get("instance").getAsString());
                }
                if (labels.has("methodName")) {
                    history.setMethodName(labels.get("methodName").getAsString());
                }
                if (labels.has("ip")) {
                    history.setAlertIp(labels.get("ip").getAsString());
                }
                if (labels.has("serverIp")) {
                    history.setAlertIp(labels.get("serverIp").getAsString());
                }
                if (labels.has("detailRedirectUrl")) {
                    url.append(labels.get("detailRedirectUrl").getAsString());
                    url.append("&start=").append(history.getAlertDate() * 1000L - 600000000L);
                    url.append("&end=").append(history.getAlertDate() * 1000L + 600000000L);
                    if (labels.has("group") && labels.has("url")) {
                        url.append("&operation=").append("/mtop/").append(labels.get("group").getAsString()).append("/").append(labels.get("url").getAsString());
                    }
                    history.setDetailedUrl(url.toString());
                    return;
                }
            }
            url.append(this.heraUrl).append("?id=").append(history.getAlertAppId()).append("&name=").append(history.getAlertApp()).append("&start_time=").append(history.getAlertDate() - 600000L).append("&end_time=").append(history.getAlertDate() + 600000L);
            if (StringUtils.isNotBlank((CharSequence)history.getAlertIp())) {
                url.append("&var-instance=").append(history.getAlertIp());
            }
            if (StringUtils.isNotBlank((CharSequence)history.getMethodName())) {
                url.append("&method_name=").append(history.getMethodName());
            }
            if ((errMetrics = this.reqErrorMetricsService.getErrorMetricsByMetrics(history.getAlertName())) != null) {
                url.append("&activeTab=exception").append("&metric=").append(errMetrics.getCode());
                history.setDetailedUrl(url.toString());
                return;
            }
            ReqSlowMetricsPOJO slowMetrics = this.reqSlowMetricsService.getSlowMetricsByMetric(history.getAlertName());
            if (slowMetrics != null) {
                url.append("&activeTab=slowQuery").append("&metric=").append(slowMetrics.getCode());
                history.setDetailedUrl(url.toString());
                return;
            }
            url.append("&activeTab=dashboard");
            history.setDetailedUrl(url.toString());
        });
        return historyList;
    }

    public AlertHistoryDetailed buildAlertHistoryDetailed(JsonObject data) {
        AlertHistoryDetailed detailed = new AlertHistoryDetailed();
        if (data.has("id")) {
            detailed.setId(data.get("id").getAsString());
        }
        if (data.has("alert_id")) {
            detailed.setAlertId(data.get("alert_id").getAsString());
        }
        if (data.has("tree_id")) {
            detailed.setIamTreeId(data.get("tree_id").getAsInt());
        }
        if (data.has("alert_name")) {
            detailed.setAlertName(data.get("alert_name").getAsString());
        }
        if (data.has("alert_cname")) {
            detailed.setAlertCName(data.get("alert_cname").getAsString());
        }
        if (data.has("alert_time")) {
            detailed.setAlertDate(CommonUtil.toMillis((Long)data.get("alert_time").getAsLong()));
        }
        if (data.has("priority")) {
            detailed.setAlertLevel(data.get("priority").getAsString());
        }
        if (data.has("status")) {
            detailed.setAlertStat(data.get("status").getAsString());
        }
        if (data.has("end_time")) {
            detailed.setAlertEndTime(CommonUtil.toMillis((Long)data.get("end_time").getAsLong()));
        }
        if (data.has("start_time")) {
            detailed.setAlertStartTime(CommonUtil.toMillis((Long)data.get("start_time").getAsLong()));
        }
        detailed.setDurationTime(this.buildDurationTime(data));
        if (data.has("labels")) {
            JsonObject labels = data.get("labels").getAsJsonObject();
            StringBuilder content = new StringBuilder();
            this.buildAlertContent(content, labels);
            this.buildDataCountContent(content, labels);
            this.buildAlarmSendInterval(content, labels);
            detailed.setAlertContent(content.toString());
            if (labels.has("project_name")) {
                detailed.setAlertApp(labels.get("project_name").getAsString());
            }
            if (labels.has("project_id")) {
                detailed.setAlertAppId(labels.get("project_id").getAsString());
            }
            if (labels.has("instance")) {
                detailed.setAlertIntance(labels.get("instance").getAsString());
            }
            if (labels.has("ip")) {
                detailed.setAlertIp(labels.get("ip").getAsString());
            }
            if (labels.has("serverIp")) {
                detailed.setAlertIp(labels.get("serverIp").getAsString());
            }
        }
        return detailed;
    }

    private void buildAlertContent(StringBuilder content, JsonObject data) {
        this.alertHelperExtension.buildAlertContent(content, data);
    }

    private String buildDurationTime(JsonObject data) {
        if (!data.has("duration")) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        Long duration = data.get("duration").getAsLong();
        if (duration < 0L) {
            duration = 0L;
        }
        if (duration < 60L) {
            content.append("\u6301\u7eed").append(duration).append("\u79d2");
        } else {
            content.append("\u6301\u7eed").append(duration / 60L).append("\u5206\u949f").append(duration % 60L).append("\u79d2");
        }
        return content.toString();
    }

    private void buildDataCountContent(StringBuilder content, JsonObject data) {
        if (!data.has("data_count")) {
            return;
        }
        AlarmCheckDataCount count = AlarmCheckDataCount.getByCode(data.get("data_count").getAsString());
        if (AlarmCheckDataCount.zero.equals((Object)count)) {
            content.append("\u7acb\u5373\u89e6\u53d1").append(", ");
            return;
        }
        content.append(count.getLabel()).append(", ");
    }

    private void buildAlarmSendInterval(StringBuilder content, JsonObject data) {
        if (!data.has("send_interval")) {
            return;
        }
        AlarmSendInterval interval = AlarmSendInterval.getEnum(data.get("send_interval").getAsString());
        if (interval == null) {
            return;
        }
        content.append("\u6bcf").append(interval.getLabel());
    }

    public List<AlertGroupMember> buildAlertGroupMemberList(JsonElement list) {
        if (list == null || !list.isJsonArray()) {
            return null;
        }
        ArrayList<AlertGroupMember> memberList = new ArrayList<AlertGroupMember>();
        list.getAsJsonArray().forEach(ele -> {
            JsonObject data = ele.getAsJsonObject();
            AlertGroupMember member = new AlertGroupMember();
            memberList.add(member);
            if (data.has("id")) {
                member.setMemberId(data.get("id").getAsLong());
            }
            if (data.has("name")) {
                member.setMember(data.get("name").getAsString());
            }
        });
        return memberList;
    }

    public List<AlertGroupInfo> buildAlertGroupInfoList(Boolean isAdmin, String user, List<AlertGroup> agList) {
        if (agList == null || agList.isEmpty()) {
            return null;
        }
        ArrayList<AlertGroupInfo> groupList = new ArrayList<AlertGroupInfo>();
        agList.forEach(ele -> groupList.add(this.buildAlertGroupInfo(isAdmin, user, (AlertGroup)ele)));
        return groupList;
    }

    public AlertGroupInfo buildAlertGroupInfo(Boolean isAdmin, String user, AlertGroup ag) {
        if (ag == null) {
            return null;
        }
        AlertGroupInfo agInfo = new AlertGroupInfo();
        agInfo.setId(ag.getId());
        agInfo.setName(ag.getName());
        agInfo.setCreatedTime(ag.getCreateTime().getTime());
        agInfo.setCreatedBy(ag.getCreater());
        agInfo.setNote(ag.getDesc());
        agInfo.setChatId(ag.getChatId());
        agInfo.setMembers(this.buildUserInfoList(ag.getMembers()));
        agInfo.setType(ag.getType());
        agInfo.setRelId(ag.getRelId());
        if (isAdmin.booleanValue() || user != null && agInfo.getMembers() != null && agInfo.getMembers().stream().filter(m -> user.equals(m.getName())).findAny().isPresent()) {
            agInfo.setDelete(true);
            agInfo.setEdit(true);
        }
        agInfo.setDutyInfo(ag.getDutyInfo() == null ? null : (DutyInfo)new Gson().fromJson(ag.getDutyInfo(), DutyInfo.class));
        return agInfo;
    }

    public List<UserInfo> buildUserInfoList(List<AlertGroupMember> agmList) {
        if (CollectionUtils.isEmpty(agmList)) {
            return null;
        }
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        agmList.forEach(ele -> {
            UserInfo user = new UserInfo();
            user.setId(ele.getMemberId());
            user.setName(ele.getMember());
            userList.add(user);
        });
        return userList;
    }

    public List<UserInfo> buildUserInfoList(JsonElement list) {
        if (list == null || !list.isJsonArray()) {
            return null;
        }
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        list.getAsJsonArray().forEach(ele -> {
            JsonObject data = ele.getAsJsonObject();
            UserInfo user = new UserInfo();
            userList.add(user);
            if (data.has("id")) {
                user.setId(data.get("id").getAsInt());
            }
            if (data.has("name")) {
                user.setName(data.get("name").getAsString());
            }
            if (data.has("cname")) {
                user.setCname(data.get("cname").getAsString());
            }
            if (data.has("email")) {
                user.setEmail(data.get("email").getAsString());
            }
        });
        return userList;
    }

    public AlertGroup buildAlertGroup(JsonObject data) {
        if (data == null) {
            return null;
        }
        AlertGroup ag = new AlertGroup();
        if (data.has("id")) {
            ag.setRelId(data.get("id").getAsLong());
        }
        if (data.has("name")) {
            ag.setName(data.get("name").getAsString());
        }
        if (data.has("note")) {
            ag.setDesc(data.get("note").getAsString());
        }
        if (data.has("chat_id")) {
            ag.setChatId(data.get("chat_id").getAsString());
        }
        if (data.has("created_by")) {
            ag.setCreater(data.get("created_by").getAsString());
        }
        if (data.has("members")) {
            ag.setMembers(this.buildAlertGroupMemberList(data.get("members")));
        }
        if (data.has("duty_info")) {
            ag.setDutyInfo(data.get("duty_info").getAsJsonObject().toString());
        }
        return ag;
    }

    public List<AlertGroupMember> getDiffAgMember(List<AlertGroupMember> oldMembers, List<AlertGroupMember> newMembers) {
        if (CollectionUtils.isEmpty(oldMembers)) {
            return newMembers;
        }
        ArrayList<AlertGroupMember> lastNewMembers = new ArrayList<AlertGroupMember>();
        for (AlertGroupMember newMember : newMembers) {
            boolean find = false;
            for (AlertGroupMember oldMember : oldMembers) {
                if (!oldMember.getMemberId().equals(newMember.getMemberId())) continue;
                find = true;
                break;
            }
            if (find) continue;
            lastNewMembers.add(newMember);
        }
        return lastNewMembers;
    }
}

