/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.extension.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ozhera.monitor.bo.Pair;
import org.apache.ozhera.monitor.bo.PlatForm;
import org.apache.ozhera.monitor.bo.PlatFormType;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class PlatFormTypeExtensionServiceImpl
implements PlatFormTypeExtensionService {
    @Override
    public boolean belongPlatForm(Integer typeCode, PlatForm platForm) {
        for (PlatFormType pft : PlatFormType.values()) {
            if (!pft.getCode().equals(typeCode) || pft.getPlatForm() != platForm) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getMarketType(Integer typeCode) {
        PlatFormType[] values;
        for (PlatFormType value : values = PlatFormType.values()) {
            if (!value.getCode().equals(typeCode)) continue;
            return value.getMarketCode();
        }
        return -1;
    }

    @Override
    public List<Pair> getPlatFormTypeDescList() {
        PlatFormType[] values;
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (PlatFormType value : values = PlatFormType.values()) {
            Pair<Integer> pair = new Pair<Integer>(value.getCode(), value.getDesc());
            list.add(pair);
        }
        return list;
    }

    @Override
    public String getGrafanaDirByTypeCode(Integer typeCode) {
        PlatFormType[] values;
        for (PlatFormType value : values = PlatFormType.values()) {
            if (!value.getCode().equals(typeCode)) continue;
            return value.getGrafanaDir();
        }
        return null;
    }

    @Override
    public boolean checkTypeCode(Integer typeCode) {
        PlatFormType[] values;
        for (PlatFormType value : values = PlatFormType.values()) {
            if (!value.getCode().equals(typeCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getTypeCodeByName(String typeName) {
        PlatFormType[] values;
        for (PlatFormType value : values = PlatFormType.values()) {
            if (!value.getName().equals(typeName)) continue;
            return value.getCode();
        }
        return null;
    }
}

