/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.model.AlertGroup;
import org.apache.ozhera.monitor.dao.model.AlertGroupMember;
import org.apache.ozhera.monitor.service.model.PageData;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.dao.util.Daos;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AlertGroupDao {
    private static final Logger log = LoggerFactory.getLogger(AlertGroupDao.class);
    @Autowired
    private Dao dao;

    public List<AlertGroup> getByIds(List<Long> ids, boolean needMember) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andInList("id", ids);
        List agList = this.dao.query(AlertGroup.class, (Condition)Cnd.where((SqlExpression)sqlExpr));
        if (CollectionUtils.isEmpty((Collection)agList) || !needMember) {
            return agList;
        }
        sqlExpr = Cnd.cri().where().andInList("alert_group_id", agList.stream().map(AlertGroup::getId).collect(Collectors.toList()));
        List agmList = this.dao.query(AlertGroupMember.class, (Condition)Cnd.where((SqlExpression)sqlExpr));
        if (!CollectionUtils.isEmpty((Collection)agmList)) {
            Map<Long, AlertGroup> agMap = agList.stream().collect(Collectors.toMap(ag -> ag.getId(), ag -> ag));
            agmList.stream().forEach(agm -> {
                AlertGroup ag = (AlertGroup)agMap.get(agm.getAlertGroupId());
                if (ag == null) {
                    return;
                }
                if (ag.getMembers() == null) {
                    ag.setMembers(new ArrayList<AlertGroupMember>());
                }
                ag.getMembers().add((AlertGroupMember)agm);
            });
        }
        return agList;
    }

    public AlertGroup getById(long id) {
        AlertGroup ag = (AlertGroup)this.dao.fetch(AlertGroup.class, id);
        if (ag == null || Integer.valueOf("1").equals(ag.getDeleted())) {
            return null;
        }
        SqlExpressionGroup sql = new SqlExpressionGroup();
        sql.andEquals("deleted", (Object)0);
        this.dao.fetchLinks((Object)ag, "members", (Condition)Cnd.where((SqlExpression)sql));
        return ag;
    }

    public AlertGroup getByRelId(String type, long relId) {
        AlertGroup ag = (AlertGroup)this.dao.fetch(AlertGroup.class, (Condition)Cnd.where((String)"rel_id", (String)"=", (Object)relId).and("type", "=", (Object)type).and("deleted", "=", (Object)0));
        if (ag == null) {
            return null;
        }
        SqlExpressionGroup sql = new SqlExpressionGroup();
        sql.andEquals("deleted", (Object)0);
        this.dao.fetchLinks((Object)ag, "members", (Condition)Cnd.where((SqlExpression)sql));
        return ag;
    }

    public List<AlertGroup> getByRelIds(String type, List<Long> relIds) {
        SqlExpressionGroup exprSql = Cnd.cri().where().andEquals("type", (Object)type).andEquals("deleted", (Object)0).andInList("rel_id", relIds);
        return this.dao.query(AlertGroup.class, (Condition)Cnd.where((SqlExpression)exprSql));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(AlertGroup alertGroup) {
        boolean result = false;
        try {
            alertGroup.setDeleted(1);
            this.dao.updateIgnoreNull((Object)alertGroup);
            this.dao.update(AlertGroupMember.class, Chain.make((String)"deleted", (Object)1), (Condition)Cnd.where((String)"alertGroupId", (String)"=", (Object)alertGroup.getId()));
        }
        catch (Throwable e) {
            log.error("\u5220\u9664\u544a\u8b66\u7ec4\u5f02\u5e38; alertGroup={}", (Object)alertGroup, (Object)e);
            result = false;
        }
        finally {
            log.info("\u5220\u9664\u544a\u8b66\u7ec4{}, result={}", (Object)alertGroup, (Object)result);
        }
        return result;
    }

    public boolean insert(AlertGroup alertGroup) {
        alertGroup.setDeleted(0);
        Date now = new Date();
        alertGroup.setUpdateTime(now);
        if (alertGroup.getCreateTime() == null) {
            alertGroup.setCreateTime(now);
        }
        if (alertGroup.getRelId() == null) {
            alertGroup.setRelId(0L);
        }
        if (StringUtils.isBlank((CharSequence)alertGroup.getType())) {
            alertGroup.setType("alert");
        }
        if (!CollectionUtils.isEmpty(alertGroup.getMembers())) {
            for (AlertGroupMember addMember : alertGroup.getMembers()) {
                addMember.setCreateTime(alertGroup.getCreateTime());
                addMember.setUpdateTime(alertGroup.getUpdateTime());
                addMember.setCreater(alertGroup.getCreater());
                addMember.setDeleted(0);
            }
        }
        try {
            this.dao.insert((Object)alertGroup);
            if (!CollectionUtils.isEmpty(alertGroup.getMembers())) {
                for (AlertGroupMember member : alertGroup.getMembers()) {
                    member.setAlertGroupId(alertGroup.getId());
                }
                this.dao.insert(alertGroup.getMembers());
            }
            return true;
        }
        catch (Throwable e) {
            log.error("HeraOperLog\u8868\u63d2\u5165\u6216\u66f4\u65b0\u5f02\u5e38\uff1b log={}", (Object)log, (Object)e);
            return false;
        }
    }

    public boolean updateById(AlertGroup alertGroup, List<AlertGroupMember> addMembers, List<AlertGroupMember> delMembers) {
        Date now = new Date();
        alertGroup.setUpdateTime(now);
        if (!CollectionUtils.isEmpty(addMembers)) {
            for (AlertGroupMember addMember : addMembers) {
                addMember.setCreateTime(now);
                addMember.setUpdateTime(now);
                addMember.setDeleted(0);
                addMember.setCreater(alertGroup.getCreater());
                addMember.setAlertGroupId(alertGroup.getId());
            }
        }
        Cnd cnd = null;
        if (!CollectionUtils.isEmpty(delMembers)) {
            long[] array = delMembers.stream().mapToLong(t -> t.getMemberId()).toArray();
            cnd = Cnd.where((SqlExpression)Cnd.cri().where().andIn("member_id", array).andEquals("alert_group_id", (Object)alertGroup.getId()));
        }
        try {
            if (cnd != null) {
                this.dao.update(AlertGroupMember.class, Chain.make((String)"deleted", (Object)1), cnd);
            }
            if (!CollectionUtils.isEmpty(addMembers)) {
                this.dao.insert(addMembers);
            }
            this.dao.updateIgnoreNull((Object)alertGroup);
            return true;
        }
        catch (Exception e) {
            log.error("HeraOperLog\u8868\u63d2\u5165\u6216\u66f4\u65b0\u5f02\u5e38\uff1b log={}", (Object)log, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageData<List<AlertGroup>> searchByCond(Boolean isAdmin, String member, String name, String type, int page, int pageSize) {
        PageData<List<AlertGroup>> pageData = new PageData<List<AlertGroup>>();
        pageData.setPage(page);
        pageData.setPageSize(pageSize);
        try {
            StringBuilder sqlB = new StringBuilder();
            sqlB.append("select ").append("ag.id,ag.rel_id,ag.name,ag.chat_id,ag.creater,ag.create_time,ag.update_time,ag.type,ag.desc").append(" from ").append("alert_group ag left join alert_group_member agm on ag.id=agm.alert_group_id").append(" where ag.deleted=0 and agm.deleted=0 ");
            if (!isAdmin.booleanValue()) {
                sqlB.append(" and agm.member='").append(member).append("'");
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                sqlB.append(" and ag.name LIKE '%").append(name).append("%'");
            }
            if (StringUtils.isNotBlank((CharSequence)type)) {
                sqlB.append(" and ag.type = '").append(type).append("'");
            }
            sqlB.append(" GROUP BY ag.id");
            sqlB.append(" order by ag.id desc");
            Sql sql = Sqls.create((String)sqlB.toString());
            long totalCount = Daos.queryCount((Dao)this.dao, (Sql)sql);
            if (totalCount <= 0L) {
                pageData.setTotal(0L);
                PageData<List<AlertGroup>> pageData2 = pageData;
                return pageData2;
            }
            pageData.setTotal(totalCount);
            sql.setPager(new Pager(page, pageSize));
            final HashMap agMap = new HashMap();
            sql.setCallback(new SqlCallback(){

                public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                    ArrayList<AlertGroup> list = new ArrayList<AlertGroup>();
                    while (rs.next()) {
                        AlertGroup ag = new AlertGroup();
                        ag.setId(rs.getLong("id"));
                        ag.setRelId(rs.getLong("rel_id"));
                        ag.setName(rs.getString("name"));
                        ag.setChatId(rs.getString("chat_id"));
                        ag.setCreater(rs.getString("creater"));
                        ag.setUpdateTime(rs.getTimestamp("update_time"));
                        ag.setCreateTime(rs.getTimestamp("create_time"));
                        ag.setType(rs.getString("type"));
                        ag.setDesc(rs.getString("desc"));
                        list.add(ag);
                        agMap.put(ag.getId(), ag);
                    }
                    return list;
                }
            });
            this.dao.execute(sql);
            pageData.setList(sql.getList(AlertGroup.class));
            if (!agMap.isEmpty()) {
                long[] array = agMap.keySet().stream().mapToLong(t -> t).toArray();
                List agmList = this.dao.query(AlertGroupMember.class, (Condition)Cnd.where((SqlExpression)Cnd.cri().where().andIn("alert_group_id", array).andEquals("deleted", (Object)"0")));
                if (!CollectionUtils.isEmpty((Collection)agmList)) {
                    agmList.forEach(agm -> {
                        AlertGroup ag = (AlertGroup)agMap.get(agm.getAlertGroupId());
                        if (ag == null) {
                            return;
                        }
                        if (ag.getMembers() == null) {
                            ag.setMembers(new ArrayList<AlertGroupMember>());
                        }
                        ag.getMembers().add((AlertGroupMember)agm);
                    });
                }
            }
            PageData<List<AlertGroup>> pageData3 = pageData;
            return pageData3;
        }
        catch (Exception e) {
            log.error("AlertGroup\u8868\u67e5\u8be2\u5f02\u5e38\uff1b member={},name={}", new Object[]{member, name, e});
            pageData.setTotal(0L);
            pageData.setList(null);
            PageData<List<AlertGroup>> pageData4 = pageData;
            return pageData4;
        }
        finally {
            log.info("AlertGroupDao.searchByCond.result pageData={}", pageData);
        }
    }
}

