/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.jcommon.log;

import ch.qos.logback.classic.pattern.ClassOfCallerConverter;
import ch.qos.logback.classic.pattern.DateConverter;
import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.MethodOfCallerConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.google.gson.Gson;
import com.xiaomi.youpin.jcommon.log.LogContext;
import com.xiaomi.youpin.jcommon.log.LogDisruptor;
import com.xiaomi.youpin.jcommon.log.LogRecord;
import com.xiaomi.youpin.jcommon.log.LogVersion;
import com.xiaomi.youpin.jcommon.log.LogbackPatternConverter;
import com.xiaomi.youpin.jcommon.log.TalosClient;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

public class YouPinLogAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private String appName;
    private String group;
    private String talosAccessKey;
    private String talosAccessSecret;
    private String talosTopicName = "youpin_common";
    private String talosSendpoint = "http://127.0.0.1";
    private String whitelist = "";
    private boolean needCatLog = false;
    private boolean disruptor = false;
    private String mdcKey = "";
    private static final AtomicBoolean isInit = new AtomicBoolean(false);
    private LineOfCallerConverter lineOfCallerConverter = new LineOfCallerConverter();
    private ClassOfCallerConverter classOfCallerConverter = new ClassOfCallerConverter();
    private MethodOfCallerConverter methodOfCallerConverter = new MethodOfCallerConverter();
    private ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();
    private DateConverter dateConverter = new DateConverter();
    private MessageConverter messageConverter = new MessageConverter();
    private TalosClient talosClient;
    private Set<String> whitelistSet = new HashSet<String>();
    private String ip = "";
    private LogDisruptor logDisruptor;

    public void start() {
        super.start();
        this.ip = System.getenv("host.ip");
        new Thread(() -> this.initYouPinLogAppender()).start();
    }

    private void initYouPinLogAppender() {
        System.out.println(new LogVersion());
        this.dateConverter.start();
        this.throwableProxyConverter.start();
        this.talosClient = new TalosClient(this.talosAccessKey, this.talosAccessSecret, this.talosTopicName, this.talosSendpoint);
        this.talosClient.init();
        if (!this.whitelist.equals("")) {
            String[] array = this.whitelist.split(",");
            Arrays.stream(array).forEach(it -> this.whitelistSet.add((String)it));
        }
        if (this.disruptor) {
            this.logDisruptor = new LogDisruptor();
            this.logDisruptor.start(lr -> this.recordLog((LogRecord)lr));
        }
        isInit.compareAndSet(false, true);
    }

    public void stop() {
        super.stop();
        if (this.talosClient != null) {
            this.talosClient.shutdown();
        }
        this.talosClient = null;
    }

    protected void append(ILoggingEvent eventObject) {
        boolean match;
        if (!isInit.get()) {
            return;
        }
        String className = this.classOfCallerConverter.convert(eventObject);
        if (className.contains("com.xiaomi.infra") || eventObject.getLoggerName().contains("com.xiaomi.infra")) {
            return;
        }
        if (!this.whitelist.equals("") && !(match = this.whitelistSet.stream().anyMatch(it -> className.contains((CharSequence)it)))) {
            return;
        }
        String threadName = eventObject.getThreadName();
        String msg = !StringUtils.isEmpty((Object)this.mdcKey) && !StringUtils.isEmpty((Object)MDC.get((String)this.mdcKey)) ? MDC.get((String)this.mdcKey) + " " + this.messageConverter.convert(eventObject) : this.messageConverter.convert(eventObject);
        String level = eventObject.getLevel().levelStr;
        String traceId = LogbackPatternConverter.traceId(eventObject);
        String time = this.dateConverter.convert(eventObject);
        String line = this.lineOfCallerConverter.convert(eventObject);
        String methodName = this.methodOfCallerConverter.convert(eventObject);
        String pid = "";
        if (this.disruptor) {
            this.logDisruptor.publishEvent(lr -> this.initLogRecord(eventObject, className, threadName, msg, level, traceId, time, line, methodName, pid, (LogRecord)lr));
            return;
        }
        LogRecord log = new LogRecord();
        this.initLogRecord(eventObject, className, threadName, msg, level, traceId, time, line, methodName, pid, log);
        this.recordLog(log);
    }

    private void recordLog(LogRecord log) {
        this.talosClient.sendMsg(new Gson().toJson((Object)log));
        this.catLog(log);
    }

    private void initLogRecord(ILoggingEvent eventObject, String className, String threadName, String msg, String level, String traceId, String time, String line, String methodName, String pid, LogRecord log) {
        log.setClassName(className);
        log.setThreadName(threadName);
        log.setMessage(msg);
        log.setLevel(level);
        log.setTraceId(traceId);
        log.setTime(time);
        log.setLine(line);
        log.setClassName(className);
        log.setMethodName(methodName);
        log.setIp(this.ip);
        log.setPid(pid);
        log.setAppName(this.appName);
        log.setGroup(this.group);
        log.setTimestamp(eventObject.getTimeStamp());
        this.setProps(eventObject, log);
        this.setException(eventObject, log);
    }

    private void catLog(LogRecord log) {
    }

    protected void setException(ILoggingEvent eventObject, LogRecord log) {
        log.setErrorInfo(this.throwableProxyConverter.convert(eventObject));
    }

    protected void setProps(ILoggingEvent eventObject, LogRecord log) {
        if (eventObject.getArgumentArray() != null && eventObject.getArgumentArray().length > 0 && eventObject.getArgumentArray()[eventObject.getArgumentArray().length - 1] != null && eventObject.getArgumentArray()[eventObject.getArgumentArray().length - 1].getClass().equals(LogContext.class)) {
            LogContext context = (LogContext)eventObject.getArgumentArray()[eventObject.getArgumentArray().length - 1];
            log.setTag(context.getTag());
            log.setParams(context.getParam());
            log.setResult(context.getResult());
            log.setCode(context.getCode());
            log.setExtra(context.getExtra());
            log.setCostTime(context.getCostTime());
            log.setErrorSource(context.getErrorSource());
            if (context.getTimestamp() > 0L) {
                log.setTimestamp(context.getTimestamp());
            }
            if (this.notEmpty(context.getTraceId())) {
                log.setTraceId(context.getTraceId());
            }
            if (this.notEmpty(context.getLevel())) {
                log.setLevel(context.getLevel());
            }
            if (this.notEmpty(context.getAppName())) {
                log.setAppName(context.getAppName());
            }
            if (this.notEmpty(context.getMethodName())) {
                log.setMethodName(context.getMethodName());
            }
        }
    }

    private boolean notEmpty(String str) {
        return null != str && !str.equals("");
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setTalosAccessKey(String talosAccessKey) {
        this.talosAccessKey = talosAccessKey;
    }

    public void setTalosAccessSecret(String talosAccessSecret) {
        this.talosAccessSecret = talosAccessSecret;
    }

    public void setTalosTopicName(String talosTopicName) {
        this.talosTopicName = talosTopicName;
    }

    public void setTalosSendpoint(String talosSendpoint) {
        this.talosSendpoint = talosSendpoint;
    }

    public void setWhitelist(String whitelist) {
        this.whitelist = whitelist;
    }

    public void setNeedCatLog(boolean needCatLog) {
        this.needCatLog = needCatLog;
    }

    public void setDisruptor(boolean disruptor) {
        this.disruptor = disruptor;
    }

    public void setMdcKey(String mdcKey) {
        this.mdcKey = mdcKey;
    }
}

