/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.controller;

import org.apache.ozhera.prometheus.agent.Commons;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.service.prometheus.ScrapeJobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class PrometheusScrapeJobController {
    private static final Logger log = LoggerFactory.getLogger(PrometheusScrapeJobController.class);
    @Autowired
    ScrapeJobService scrapeJobService;

    @RequestMapping(value={"/scrape-config"}, method={RequestMethod.POST})
    public Result CreateScrapeConfig(@RequestBody ScrapeConfigParam param) {
        return this.scrapeJobService.CreateScrapeConfig(param);
    }

    @RequestMapping(value={"/scrape-config/{id}"}, method={RequestMethod.DELETE})
    public Result DeleteScrapeConfig(@PathVariable String id) {
        return this.scrapeJobService.DeleteScrapeConfig(id);
    }

    @RequestMapping(value={"/scrape-config/{id}"}, method={RequestMethod.PUT})
    public Result UpdateScrapeConfig(@PathVariable String id, @RequestBody ScrapeConfigParam entity) {
        Result result = this.scrapeJobService.UpdateScrapeConfig(id, entity);
        return result;
    }

    @RequestMapping(value={"/scrape-config/{id}"}, method={RequestMethod.GET})
    public Result GetScrapeConfig(@PathVariable String id) {
        return this.scrapeJobService.GetScrapeConfig(id);
    }

    @RequestMapping(value={"/scrape-config/list"}, method={RequestMethod.GET})
    public Result GetScrapeConfigList(Integer page_size, Integer page_no) {
        if (page_size == null && page_no == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (page_size == null) {
            page_size = Commons.COMMON_PAGE_SIZE;
        }
        if (page_no == null) {
            page_no = Commons.COMMON_PAGE_NO;
        }
        Result result = this.scrapeJobService.GetScrapeConfigList(page_size, page_no);
        return result;
    }
}

